/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MissingOverrideAnnotationInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreObjectMethods = true;
    public boolean ignoreAnonymousClassMethods = false;

    @NotNull
    public String getID() {
        if ("override" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection", "getID"));
        }
        return "override";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("missing.override.annotation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("missing.override.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("ignore.equals.hashcode.and.tostring", new Object[0]), "ignoreObjectMethods");
        panel2.addCheckbox(InspectionGadgetsBundle.message("ignore.methods.in.anonymous.classes", new Object[0]), "ignoreAnonymousClassMethods");
        return panel2;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MissingOverrideAnnotationFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MissingOverrideAnnotationVisitor();
    }

    private class MissingOverrideAnnotationVisitor
    extends BaseInspectionVisitor {
        private MissingOverrideAnnotationVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection$MissingOverrideAnnotationVisitor", "visitMethod"));
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (method.isConstructor()) {
                return;
            }
            if (method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
                return;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return;
            }
            if (MissingOverrideAnnotationInspection.this.ignoreAnonymousClassMethods && methodClass instanceof PsiAnonymousClass) {
                return;
            }
            if (this.hasOverrideAnnotation((PsiModifierListOwner)method)) {
                return;
            }
            boolean useJdk6Rules = PsiUtil.isLanguageLevel6OrHigher((PsiElement)method);
            if (useJdk6Rules ? !this.isJdk6Override(method, methodClass) : !this.isJdk5Override(method, methodClass)) {
                return;
            }
            if (MissingOverrideAnnotationInspection.this.ignoreObjectMethods && (MethodUtils.isHashCode(method) || MethodUtils.isEquals(method) || MethodUtils.isToString(method))) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean hasOverrideAnnotation(PsiModifierListOwner element) {
            PsiModifierList modifierList = element.getModifierList();
            return modifierList != null && modifierList.findAnnotation("java.lang.Override") != null;
        }

        private boolean isJdk6Override(PsiMethod method, PsiClass methodClass) {
            PsiMethod[] superMethods = method.findSuperMethods();
            boolean hasSupers = false;
            for (PsiMethod superMethod : superMethods) {
                PsiClass superClass = superMethod.getContainingClass();
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)methodClass, (PsiClass)superClass, (boolean)true)) continue;
                hasSupers = true;
                if (superMethod.hasModifierProperty("protected")) continue;
                return true;
            }
            return hasSupers && !methodClass.isInterface();
        }

        private boolean isJdk5Override(PsiMethod method, PsiClass methodClass) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)methodClass, (PsiClass)superClass, (boolean)true) || superClass.isInterface() || methodClass.isInterface() && superMethod.hasModifierProperty("protected")) continue;
                return true;
            }
            return false;
        }
    }

    private static class MissingOverrideAnnotationFix
    extends InspectionGadgetsFix {
        private MissingOverrideAnnotationFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("missing.override.annotation.add.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/MissingOverrideAnnotationInspection$MissingOverrideAnnotationFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement identifier = descriptor.getPsiElement();
            PsiElement parent = identifier.getParent();
            if (!(parent instanceof PsiModifierListOwner)) {
                return;
            }
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)parent;
            PsiModifierList modifierList = modifierListOwner.getModifierList();
            if (modifierList == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            modifierList.addAfter((PsiElement)factory.createAnnotationFromText("@java.lang.Override", (PsiElement)modifierListOwner), null);
        }
    }
}

