/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class AbstractMethodCallInConstructorInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("abstract.method.call.in.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/AbstractMethodCallInConstructorInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("abstract.method.call.in.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/AbstractMethodCallInConstructorInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractMethodCallInConstructorVisitor();
    }

    private static class AbstractMethodCallInConstructorVisitor
    extends BaseInspectionVisitor {
        private AbstractMethodCallInConstructorVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/initialization/AbstractMethodCallInConstructorInspection$AbstractMethodCallInConstructorVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression2);
            if (!MethodCallUtils.isCallDuringObjectConstruction(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return;
            }
            PsiMethod calledMethod = (PsiMethod)methodExpression.resolve();
            if (calledMethod == null || calledMethod.isConstructor() || !calledMethod.hasModifierProperty("abstract")) {
                return;
            }
            PsiClass calledMethodClass = calledMethod.getContainingClass();
            if (calledMethodClass == null) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class);
            if (!calledMethodClass.equals(containingClass)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }
}

