/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public class NonThreadSafeLazyInitializationInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.thread.safe.lazy.initialization.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/NonThreadSafeLazyInitializationInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.thread.safe.lazy.initialization.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/NonThreadSafeLazyInitializationInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnsafeSafeLazyInitializationVisitor();
    }

    private static class UnsafeSafeLazyInitializationVisitor
    extends BaseInspectionVisitor {
        private UnsafeSafeLazyInitializationVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/initialization/NonThreadSafeLazyInitializationInspectionBase$UnsafeSafeLazyInitializationVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(expression2);
            PsiExpression lhs = expression2.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            if (!field.hasModifierProperty("static")) {
                return;
            }
            if (UnsafeSafeLazyInitializationVisitor.isInStaticInitializer((PsiElement)expression2)) {
                return;
            }
            if (UnsafeSafeLazyInitializationVisitor.isInSynchronizedContext((PsiElement)expression2)) {
                return;
            }
            PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class);
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)statement2, (Class[])new Class[]{PsiCodeBlock.class, PsiBlockStatement.class});
            if (!(parent instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null || !ComparisonUtils.isNullComparison(condition2, (PsiVariable)field, true)) {
                return;
            }
            this.registerError((PsiElement)lhs, ifStatement, field);
        }

        private static boolean isInSynchronizedContext(PsiElement element) {
            PsiSynchronizedStatement syncBlock = (PsiSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiSynchronizedStatement.class);
            if (syncBlock != null) {
                return true;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            return method != null && method.hasModifierProperty("synchronized") && method.hasModifierProperty("static");
        }

        private static boolean isInStaticInitializer(PsiElement element) {
            PsiClassInitializer initializer = (PsiClassInitializer)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClassInitializer.class);
            return initializer != null && initializer.hasModifierProperty("static");
        }
    }
}

