/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousGetterSetterInspection
extends BaseInspection {
    public boolean onlyWarnWhenFieldPresent = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("suspicious.getter.setter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javabeans/SuspiciousGetterSetterInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = (Boolean)infos[0] != false ? InspectionGadgetsBundle.message("suspicious.setter.problem.descriptor", infos[1]) : InspectionGadgetsBundle.message("suspicious.getter.problem.descriptor", infos[1]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javabeans/SuspiciousGetterSetterInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Only warn when field matching getter/setter name is present", (InspectionProfileEntry)this, "onlyWarnWhenFieldPresent");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousGetterSetterVisitor();
    }

    private static boolean nameStartsWith(String name2, String prefix) {
        return name2.startsWith(prefix) && name2.length() != prefix.length() && Character.isUpperCase(name2.charAt(prefix.length()));
    }

    private class SuspiciousGetterSetterVisitor
    extends BaseInspectionVisitor {
        private SuspiciousGetterSetterVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            boolean setter;
            String extractedFieldName;
            String fieldName;
            PsiField getterField;
            super.visitMethod(method);
            String name2 = method.getName();
            if (SuspiciousGetterSetterInspection.nameStartsWith(name2, "get")) {
                getterField = PropertyUtil.getFieldOfGetter((PsiMethod)method);
                if (getterField == null) {
                    return;
                }
                fieldName = getterField.getName();
                extractedFieldName = name2.substring(3);
                setter = false;
            } else if (SuspiciousGetterSetterInspection.nameStartsWith(name2, "is")) {
                getterField = PropertyUtil.getFieldOfGetter((PsiMethod)method);
                if (getterField == null) {
                    return;
                }
                fieldName = getterField.getName();
                extractedFieldName = name2.substring(2);
                setter = false;
            } else if (SuspiciousGetterSetterInspection.nameStartsWith(name2, "set")) {
                PsiField setterField = PropertyUtil.getFieldOfSetter((PsiMethod)method);
                if (setterField == null) {
                    return;
                }
                fieldName = setterField.getName();
                extractedFieldName = name2.substring(3);
                setter = true;
            } else {
                return;
            }
            if (fieldName == null) {
                return;
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)method.getProject());
            String computedFieldName = codeStyleManager.propertyNameToVariableName(extractedFieldName, VariableKind.FIELD);
            String computedStaticFieldName = codeStyleManager.propertyNameToVariableName(extractedFieldName, VariableKind.STATIC_FINAL_FIELD);
            if (fieldName.equalsIgnoreCase(computedFieldName) || fieldName.equalsIgnoreCase(computedStaticFieldName)) {
                return;
            }
            if (SuspiciousGetterSetterInspection.this.onlyWarnWhenFieldPresent) {
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return;
                }
                if (aClass.findFieldByName(computedFieldName, true) == null && aClass.findFieldByName(computedStaticFieldName, true) == null) {
                    return;
                }
            }
            this.registerMethodError(method, setter, fieldName);
        }
    }
}

