/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.VisibilityUtil;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

class MakePublicStaticVoidFix
extends InspectionGadgetsFix {
    private final String myName;
    private final boolean myMakeStatic;
    private final String myNewVisibility;

    public MakePublicStaticVoidFix(PsiMethod method, boolean makeStatic) {
        this(method, makeStatic, "public");
    }

    public MakePublicStaticVoidFix(PsiMethod method, boolean makeStatic, @PsiModifier.ModifierConstant String newVisibility) {
        String presentableVisibility = VisibilityUtil.getVisibilityString((String)newVisibility);
        this.myName = "Change signature of '" + PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)267, (int)2) + "' to '" + (presentableVisibility.isEmpty() ? "" : presentableVisibility + " ") + (makeStatic ? "static " : "") + "void " + method.getName() + "()'";
        this.myMakeStatic = makeStatic;
        this.myNewVisibility = newVisibility;
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor) {
        final PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
        if (method != null) {
            ChangeSignatureProcessor csp = new ChangeSignatureProcessor(project2, method, false, this.myNewVisibility, method.getName(), (PsiType)PsiType.VOID, new ParameterInfoImpl[0]){

                @Override
                protected void performRefactoring(@NotNull UsageInfo[] usages) {
                    if (usages == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/siyeh/ig/junit/MakePublicStaticVoidFix$1", "performRefactoring"));
                    }
                    super.performRefactoring(usages);
                    PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)MakePublicStaticVoidFix.this.myMakeStatic);
                }
            };
            csp.run();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if ("Fix modifiers" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/MakePublicStaticVoidFix", "getFamilyName"));
        }
        return "Fix modifiers";
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/MakePublicStaticVoidFix", "getName"));
        }
        return string;
    }
}

