/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SuperTearDownInFinallyInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("super.tear.down.in.finally.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/SuperTearDownInFinallyInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("super.tear.down.in.finally.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/SuperTearDownInFinallyInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuperTearDownInFinallyVisitor();
    }

    private static class SuperTearDownInFinallyVisitor
    extends BaseInspectionVisitor {
        private SuperTearDownInFinallyVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiCodeBlock finallyBlock;
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
            if (method == null || !method.getName().equals("tearDown")) {
                return;
            }
            if (!MethodCallUtils.isSuperMethodCall(expression2, method)) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"junit.framework.TestCase")) {
                return;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
            if (tryStatement != null && PsiTreeUtil.isAncestor((PsiElement)(finallyBlock = tryStatement.getFinallyBlock()), (PsiElement)expression2, (boolean)true)) {
                return;
            }
            if (!SuperTearDownInFinallyVisitor.hasNonTrivialActivity(method, (PsiElement)expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean hasNonTrivialActivity(PsiMethod method, PsiElement ignore) {
            NonTrivialActivityVisitor visitor = new NonTrivialActivityVisitor(ignore);
            method.accept((PsiElementVisitor)visitor);
            return visitor.hasNonTrivialActivity();
        }

        private static class NonTrivialActivityVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final PsiElement myIgnore;
            private boolean nonTrivialActivity = false;

            public NonTrivialActivityVisitor(PsiElement ignore) {
                this.myIgnore = ignore;
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                super.visitMethodCallExpression(expression2);
                if (expression2 == this.myIgnore) {
                    return;
                }
                this.nonTrivialActivity = true;
            }

            public boolean hasNonTrivialActivity() {
                return this.nonTrivialActivity;
            }
        }
    }
}

