/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClassWithMultipleLoggersInspectionBase
extends BaseInspection {
    protected final List<String> loggerNames = new ArrayList<String>();
    @NonNls
    public String loggerNamesString = "java.util.logging.Logger,org.slf4j.Logger,org.apache.commons.logging.Log,org.apache.log4j.Logger";

    public ClassWithMultipleLoggersInspectionBase() {
        ClassWithMultipleLoggersInspectionBase.parseString(this.loggerNamesString, this.loggerNames);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multiple.loggers.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/ClassWithMultipleLoggersInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("multiple.loggers.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/ClassWithMultipleLoggersInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/logging/ClassWithMultipleLoggersInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        ClassWithMultipleLoggersInspectionBase.parseString(this.loggerNamesString, this.loggerNames);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/logging/ClassWithMultipleLoggersInspectionBase", "writeSettings"));
        }
        this.loggerNamesString = ClassWithMultipleLoggersInspectionBase.formatString(this.loggerNames);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithMultipleLoggersVisitor();
    }

    private class ClassWithMultipleLoggersVisitor
    extends BaseInspectionVisitor {
        private ClassWithMultipleLoggersVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiField[] fields;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/logging/ClassWithMultipleLoggersInspectionBase$ClassWithMultipleLoggersVisitor", "visitClass"));
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (aClass.getContainingClass() != null) {
                return;
            }
            int numLoggers = 0;
            for (PsiField field : fields = aClass.getFields()) {
                if (!this.isLogger((PsiVariable)field)) continue;
                ++numLoggers;
            }
            if (numLoggers <= 1) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private boolean isLogger(PsiVariable variable) {
            PsiType type2 = variable.getType();
            String text2 = type2.getCanonicalText();
            return ClassWithMultipleLoggersInspectionBase.this.loggerNames.contains(text2);
        }
    }
}

