/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class LambdaUnfriendlyMethodOverloadInspectionBase
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.unfriendly.method.overload.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/LambdaUnfriendlyMethodOverloadInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        String string = InspectionGadgetsBundle.message(method.isConstructor() ? "lambda.unfriendly.constructor.overload.problem.descriptor" : "lambda.unfriendly.method.overload.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/LambdaUnfriendlyMethodOverloadInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LambdaUnfriendlyMethodOverloadVisitor();
    }

    private static class LambdaUnfriendlyMethodOverloadVisitor
    extends BaseInspectionVisitor {
        private LambdaUnfriendlyMethodOverloadVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiParameterList parameterList = method.getParameterList();
            int parametersCount = parameterList.getParametersCount();
            if (parametersCount == 0) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            int functionalIndex = -1;
            for (int i2 = 0; i2 < parameters2.length; ++i2) {
                PsiParameter parameter = parameters2[i2];
                if (!LambdaUtil.isFunctionalType((PsiType)parameter.getType())) continue;
                functionalIndex = i2;
                break;
            }
            if (functionalIndex < 0) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String name2 = method.getName();
            for (PsiMethod sameNameMethod : containingClass.findMethodsByName(name2, true)) {
                PsiParameterList otherParameterList;
                if (method.equals(sameNameMethod) || PsiSuperMethodUtil.isSuperMethod((PsiMethod)method, (PsiMethod)sameNameMethod) || parametersCount != (otherParameterList = sameNameMethod.getParameterList()).getParametersCount()) continue;
                PsiParameter[] otherParameters = otherParameterList.getParameters();
                PsiType otherFunctionalType = otherParameters[functionalIndex].getType();
                PsiType functionalType = parameters2[functionalIndex].getType();
                if (!LambdaUnfriendlyMethodOverloadVisitor.areOtherParameterTypesConvertible(parameters2, otherParameters, functionalIndex) || !LambdaUtil.isFunctionalType((PsiType)otherFunctionalType) || Objects.equals(functionalType, otherFunctionalType) || !LambdaUnfriendlyMethodOverloadVisitor.areSameShapeFunctionalTypes(functionalType, otherFunctionalType)) continue;
                this.registerMethodError(method, method);
                return;
            }
        }

        private static boolean areSameShapeFunctionalTypes(PsiType one, PsiType two) {
            PsiMethod method1 = LambdaUtil.getFunctionalInterfaceMethod((PsiType)one);
            PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod((PsiType)two);
            if (method1 == null || method2 == null) {
                return false;
            }
            PsiType returnType1 = method1.getReturnType();
            PsiType returnType2 = method2.getReturnType();
            if (PsiType.VOID.equals((Object)returnType1) ^ PsiType.VOID.equals((Object)returnType2)) {
                return false;
            }
            return method1.getParameterList().getParametersCount() == method2.getParameterList().getParametersCount();
        }

        private static boolean areOtherParameterTypesConvertible(PsiParameter[] parameters2, PsiParameter[] otherParameters, int notThisOne) {
            for (int i2 = 0; i2 < parameters2.length; ++i2) {
                PsiType otherType;
                PsiType type2;
                if (i2 == notThisOne || (type2 = TypeConversionUtil.erasure((PsiType)parameters2[i2].getType())).isAssignableFrom(otherType = TypeConversionUtil.erasure((PsiType)otherParameters[i2].getType())) || otherType.isAssignableFrom(type2)) continue;
                return false;
            }
            return true;
        }
    }
}

