/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NonBooleanMethodNameMayNotStartWithQuestionInspectionBase
extends BaseInspection {
    @NonNls
    public String questionString = "add,are,can,check,contains,could,endsWith,equals,has,is,matches,must,put,remove,shall,should,startsWith,was,were,will,would";
    public boolean ignoreBooleanMethods = false;
    public boolean onlyWarnOnBaseMethods = true;
    List<String> questionList = new ArrayList<String>(32);

    public NonBooleanMethodNameMayNotStartWithQuestionInspectionBase() {
        NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.parseString(this.questionString, this.questionList);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.boolean.method.name.must.not.start.with.question.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/NonBooleanMethodNameMayNotStartWithQuestionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.boolean.method.name.must.not.start.with.question.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/NonBooleanMethodNameMayNotStartWithQuestionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/naming/NonBooleanMethodNameMayNotStartWithQuestionInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.parseString(this.questionString, this.questionList);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/naming/NonBooleanMethodNameMayNotStartWithQuestionInspectionBase", "writeSettings"));
        }
        this.questionString = NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.formatString(this.questionList);
        super.writeSettings(element);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonBooleanMethodNameMayNotStartWithQuestionVisitor();
    }

    private class NonBooleanMethodNameMayNotStartWithQuestionVisitor
    extends BaseInspectionVisitor {
        private NonBooleanMethodNameMayNotStartWithQuestionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/NonBooleanMethodNameMayNotStartWithQuestionInspectionBase$NonBooleanMethodNameMayNotStartWithQuestionVisitor", "visitMethod"));
            }
            super.visitMethod(method);
            PsiType returnType = method.getReturnType();
            if (returnType == null || returnType.equals(PsiType.BOOLEAN)) {
                return;
            }
            if (NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.this.ignoreBooleanMethods && returnType.equalsToText("java.lang.Boolean")) {
                return;
            }
            String name2 = method.getName();
            boolean startsWithQuestionWord = false;
            for (String question : NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.this.questionList) {
                if (!name2.startsWith(question)) continue;
                if (name2.length() == question.length()) {
                    startsWithQuestionWord = true;
                    break;
                }
                char nextChar = name2.charAt(question.length());
                if (!Character.isUpperCase(nextChar) && nextChar != '_') continue;
                startsWithQuestionWord = true;
                break;
            }
            if (!startsWithQuestionWord) {
                return;
            }
            if (NonBooleanMethodNameMayNotStartWithQuestionInspectionBase.this.onlyWarnOnBaseMethods ? MethodUtils.hasSuper(method) : LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            this.registerMethodError(method, method);
        }
    }
}

