/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class CastThatLosesPrecisionInspection
extends BaseInspection {
    public boolean ignoreIntegerCharCasts = false;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("NumericCastThatLosesPrecision" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection", "getID"));
        }
        return "NumericCastThatLosesPrecision";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cast.that.loses.precision.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType operandType = (PsiType)infos[0];
        boolean negativeOnly = (Boolean)infos[1];
        String string = InspectionGadgetsBundle.message(negativeOnly ? "cast.that.loses.precision.negative.problem.descriptor" : "cast.that.loses.precision.problem.descriptor", operandType.getPresentableText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("cast.that.loses.precision.option", new Object[0]), (InspectionProfileEntry)this, "ignoreIntegerCharCasts");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CastThatLosesPrecisionVisitor();
    }

    private class CastThatLosesPrecisionVisitor
    extends BaseInspectionVisitor {
        private CastThatLosesPrecisionVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression2) {
            LongRangeSet valueRange;
            Number number;
            PsiMethod method;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection$CastThatLosesPrecisionVisitor", "visitTypeCastExpression"));
            }
            PsiType castType = expression2.getType();
            if (!ClassUtils.isPrimitiveNumericType(castType)) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiType operandType = operand2.getType();
            if (!ClassUtils.isPrimitiveNumericType(operandType) || !TypeUtils.isNarrowingConversion(operandType, castType)) {
                return;
            }
            if (CastThatLosesPrecisionInspection.this.ignoreIntegerCharCasts && PsiType.INT.equals((Object)operandType) && PsiType.CHAR.equals((Object)castType)) {
                return;
            }
            if (PsiType.LONG.equals((Object)operandType) && PsiType.INT.equals((Object)castType) && MethodUtils.isHashCode(method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}))) {
                return;
            }
            Object result2 = ExpressionUtils.computeConstantExpression(operand2);
            if (result2 instanceof Character) {
                result2 = (int)((Character)result2).charValue();
            }
            if (result2 instanceof Number && this.valueIsContainableInType(number = (Number)result2, castType)) {
                return;
            }
            PsiTypeElement castTypeElement = expression2.getCastType();
            if (castTypeElement == null) {
                return;
            }
            LongRangeSet targetRange = LongRangeSet.fromType(castType);
            LongRangeSet lostRange = LongRangeSet.all();
            if (targetRange != null && LongRangeSet.fromType(operandType) != null && (lostRange = (valueRange = this.getValueRange(operand2)).subtract(targetRange)).isEmpty()) {
                return;
            }
            this.registerError((PsiElement)castTypeElement, operandType, lostRange.max() < 0L);
        }

        private LongRangeSet getValueRange(final @NotNull PsiExpression operand2) {
            if (operand2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection$CastThatLosesPrecisionVisitor", "getValueRange"));
            }
            Object parent = PsiTreeUtil.getParentOfType((PsiElement)operand2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiClass.class});
            parent = parent instanceof PsiMethod ? ((PsiMethod)parent).getBody() : (parent instanceof PsiLambdaExpression ? ((PsiLambdaExpression)parent).getBody() : null);
            if (parent == null) {
                return LongRangeSet.all();
            }
            StandardDataFlowRunner runner = new StandardDataFlowRunner(false, false);
            final Ref range = Ref.create((Object)LongRangeSet.empty());
            RunnerResult runnerResult = runner.analyzeMethod((PsiElement)parent, new StandardInstructionVisitor(){

                @Override
                public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                    if (instruction.getMethodType() == MethodCallInstruction.MethodType.CAST && instruction.getContext() == operand2) {
                        LongRangeSet curRange = memState.getValueFact(DfaFactType.RANGE, memState.peek());
                        if (curRange == null) {
                            range.set((Object)LongRangeSet.all());
                        } else {
                            range.set((Object)((LongRangeSet)range.get()).union(curRange));
                        }
                    }
                    return super.visitMethodCall(instruction, runner, memState);
                }
            });
            return runnerResult == RunnerResult.OK ? (LongRangeSet)range.get() : LongRangeSet.all();
        }

        private boolean valueIsContainableInType(Number value2, PsiType type2) {
            long longValue = value2.longValue();
            double doubleValue = value2.doubleValue();
            if (PsiType.BYTE.equals((Object)type2)) {
                return longValue >= -128L && longValue <= 127L && doubleValue >= -128.0 && doubleValue <= 127.0;
            }
            if (PsiType.CHAR.equals((Object)type2)) {
                return longValue >= 0L && longValue <= 65535L && doubleValue >= 0.0 && doubleValue <= 65535.0;
            }
            if (PsiType.SHORT.equals((Object)type2)) {
                return longValue >= -32768L && longValue <= 32767L && doubleValue >= -32768.0 && doubleValue <= 32767.0;
            }
            if (PsiType.INT.equals((Object)type2)) {
                return longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE && doubleValue >= -2.147483648E9 && doubleValue <= 2.147483647E9;
            }
            if (PsiType.LONG.equals((Object)type2)) {
                return doubleValue >= -9.223372036854776E18 && doubleValue <= 9.223372036854776E18;
            }
            if (PsiType.FLOAT.equals((Object)type2)) {
                return doubleValue == (double)value2.floatValue();
            }
            return PsiType.DOUBLE.equals((Object)type2);
        }
    }
}

