/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class FloatingPointEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("floating.point.equality.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/FloatingPointEqualityInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("floating.point.equality.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/FloatingPointEqualityInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FloatingPointEqualityComparisonVisitor();
    }

    private static class FloatingPointEqualityComparisonVisitor
    extends BaseInspectionVisitor {
        private FloatingPointEqualityComparisonVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/FloatingPointEqualityInspection$FloatingPointEqualityComparisonVisitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression2);
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            if (!TypeUtils.hasFloatingPointType(lhs) && !TypeUtils.hasFloatingPointType(rhs)) {
                return;
            }
            if (FloatingPointEqualityComparisonVisitor.isInfinityOrZero(lhs) || FloatingPointEqualityComparisonVisitor.isInfinityOrZero(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private static boolean isInfinityOrZero(PsiExpression expression2) {
            Object value2 = ExpressionUtils.computeConstantExpression(expression2);
            if (value2 instanceof Double) {
                Double aDouble = (Double)value2;
                double v = aDouble;
                return Double.isInfinite(v) || v == 0.0;
            }
            if (value2 instanceof Float) {
                Float aFloat = (Float)value2;
                float v = aFloat.floatValue();
                return Float.isInfinite(v) || v == 0.0f;
            }
            if (value2 instanceof Integer) {
                Integer integer = (Integer)value2;
                return integer == 0;
            }
            if (value2 instanceof Long) {
                Long aLong = (Long)value2;
                return aLong == 0L;
            }
            return false;
        }
    }
}

