/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BooleanConstructorInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("BooleanConstructorCall" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/BooleanConstructorInspection", "getID"));
        }
        return "BooleanConstructorCall";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("boolean.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/BooleanConstructorInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("boolean.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/BooleanConstructorInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanConstructorVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new BooleanConstructorFix();
    }

    private static class BooleanConstructorVisitor
    extends BaseInspectionVisitor {
        private BooleanConstructorVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            String qualifiedName;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/BooleanConstructorInspection$BooleanConstructorVisitor", "visitNewExpression"));
            }
            super.visitNewExpression(expression2);
            PsiType type2 = expression2.getType();
            if (type2 == null || !type2.equalsToText("java.lang.Boolean")) {
                return;
            }
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)expression2);
            if (aClass != null && "java.lang.Boolean".equals(qualifiedName = aClass.getQualifiedName())) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] expressions2 = argumentList.getExpressions();
            if (expressions2.length != 1) {
                return;
            }
            this.registerNewExpressionError(expression2, new Object[0]);
        }
    }

    private static class BooleanConstructorFix
    extends InspectionGadgetsFix {
        private static final String TRUE = "\"true\"";
        private static final String FALSE = "\"false\"";

        private BooleanConstructorFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("boolean.constructor.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/BooleanConstructorInspection$BooleanConstructorFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            String newExpression;
            PsiElement element = descriptor.getPsiElement().getParent();
            if (!(element instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression expression2 = (PsiNewExpression)element;
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            String text2 = argument.getText();
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)expression2);
            if ("true".equals(text2) || TRUE.equalsIgnoreCase(text2)) {
                newExpression = "java.lang.Boolean.TRUE";
            } else if ("false".equals(text2) || FALSE.equalsIgnoreCase(text2)) {
                newExpression = "java.lang.Boolean.FALSE";
            } else if (languageLevel.equals((Object)LanguageLevel.JDK_1_3)) {
                newExpression = BooleanConstructorFix.buildText(argument, false);
            } else {
                PsiClass booleanClass = ClassUtils.findClass("java.lang.Boolean", (PsiElement)argument);
                boolean methodFound = false;
                if (booleanClass != null) {
                    PsiMethod[] methods;
                    for (PsiMethod method : methods = booleanClass.findMethodsByName("valueOf", false)) {
                        PsiParameter parameter;
                        PsiType type2;
                        PsiParameterList parameterList = method.getParameterList();
                        PsiParameter[] parameters2 = parameterList.getParameters();
                        if (parameters2.length == 0 || !PsiType.BOOLEAN.equals((Object)(type2 = (parameter = parameters2[0]).getType()))) continue;
                        methodFound = true;
                        break;
                    }
                }
                newExpression = BooleanConstructorFix.buildText(argument, methodFound);
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression);
        }

        @NonNls
        private static String buildText(PsiExpression argument, boolean useValueOf) {
            String text2 = argument.getText();
            PsiType argumentType = argument.getType();
            if (!useValueOf && PsiType.BOOLEAN.equals((Object)argumentType)) {
                if (ParenthesesUtils.getPrecedence(argument) > 15) {
                    return text2 + "?java.lang.fBoolean.TRUE:java.lang.Boolean.FALSE";
                }
                return '(' + text2 + ")?java.lang.Boolean.TRUE:java.lang.Boolean.FALSE";
            }
            return "java.lang.Boolean.valueOf(" + text2 + ')';
        }
    }
}

