/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeySetIterationMayUseEntrySetInspection
extends BaseInspection {
    @Override
    @NotNull
    @Nls
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("key.set.iteration.may.use.entry.set.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("key.set.iteration.may.use.entry.set.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new KeySetIterationMapUseEntrySetFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new KeySetIterationMayUseEntrySetVisitor();
    }

    private static class GetValueFromMapChecker
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiVariable key;
        private final PsiVariable map;
        private boolean getValueFromMap;
        private boolean tainted;

        GetValueFromMapChecker(@NotNull PsiVariable map2, @NotNull PsiVariable key2) {
            if (map2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$GetValueFromMapChecker", "<init>"));
            }
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$GetValueFromMapChecker", "<init>"));
            }
            this.map = map2;
            this.key = key2;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (this.tainted) {
                return;
            }
            super.visitReferenceExpression(expression2);
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiAssignmentExpression) {
                PsiElement target2 = expression2.resolve();
                if (this.key.equals(target2) || this.map.equals(target2)) {
                    this.tainted = true;
                }
            } else if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)parent;
            PsiElement target3 = expression2.resolve();
            if (!this.map.equals(target3)) {
                return;
            }
            PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
            if (qualifierExpression2 != null && !(qualifierExpression2 instanceof PsiThisExpression) && !(qualifierExpression2 instanceof PsiSuperExpression)) {
                return;
            }
            String methodName = methodExpression.getReferenceName();
            if (!"get".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (!(argument instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)argument;
            PsiElement argumentTarget = referenceExpression.resolve();
            if (!this.key.equals(argumentTarget)) {
                return;
            }
            this.getValueFromMap = true;
        }

        boolean isGetValueFromMap() {
            return this.getValueFromMap && !this.tainted;
        }
    }

    private static class KeySetIterationMayUseEntrySetVisitor
    extends BaseInspectionVisitor {
        private KeySetIterationMayUseEntrySetVisitor() {
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            PsiExpression iteratedExpression;
            super.visitForeachStatement(statement2);
            PsiExpression iteratedValue2 = ParenthesesUtils.stripParentheses(statement2.getIteratedValue());
            if (iteratedValue2 == null) {
                return;
            }
            if (iteratedValue2 instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)iteratedValue2;
                PsiElement target2 = referenceExpression.resolve();
                if (!(target2 instanceof PsiLocalVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target2;
                PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiMethod.class);
                if (VariableAccessUtils.variableIsAssignedAtPoint(variable, (PsiElement)containingMethod, (PsiElement)statement2)) {
                    return;
                }
                iteratedExpression = variable.getInitializer();
            } else {
                iteratedExpression = iteratedValue2;
            }
            PsiParameter parameter = statement2.getIterationParameter();
            if (!KeySetIterationMayUseEntrySetVisitor.isMapKeySetIteration(iteratedExpression, (PsiVariable)parameter, (PsiElement)statement2.getBody())) {
                return;
            }
            this.registerError((PsiElement)iteratedValue2, new Object[0]);
        }

        private static boolean isMapKeySetIteration(PsiExpression iteratedExpression, PsiVariable key2, @Nullable PsiElement context) {
            if (context == null) {
                return false;
            }
            if (!(iteratedExpression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)iteratedExpression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"keySet".equals(methodName)) {
                return false;
            }
            PsiExpression expression2 = methodExpression.getQualifierExpression();
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement target2 = referenceExpression.resolve();
            if (!(target2 instanceof PsiVariable)) {
                return false;
            }
            PsiVariable targetVariable = (PsiVariable)target2;
            if (!TypeUtils.variableHasTypeOrSubtype(targetVariable, "java.util.Map")) {
                return false;
            }
            GetValueFromMapChecker checker = new GetValueFromMapChecker(targetVariable, key2);
            context.accept((PsiElementVisitor)checker);
            return checker.isGetValueFromMap();
        }
    }

    private static class KeySetIterationMapUseEntrySetFix
    extends InspectionGadgetsFix {
        private KeySetIterationMapUseEntrySetFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("key.set.iteration.may.use.entry.set.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiModifierList modifierList;
            PsiElement map2;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses(element);
            if (!(parent instanceof PsiForeachStatement)) {
                return;
            }
            if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement target2 = referenceExpression.resolve();
                if (!(target2 instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target2;
                PsiExpression initializer = variable.getInitializer();
                if (!(initializer instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)initializer;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression reference = (PsiReferenceExpression)qualifier;
                map2 = reference.resolve();
                String qualifierText = qualifier.getText();
                PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, qualifierText + ".entrySet()");
            } else if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                map2 = referenceExpression.resolve();
                String qualifierText = qualifier.getText();
                PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, qualifierText + ".entrySet()");
            } else {
                return;
            }
            PsiForeachStatement foreachStatement = (PsiForeachStatement)parent;
            PsiExpression iteratedValue2 = foreachStatement.getIteratedValue();
            if (iteratedValue2 == null) {
                return;
            }
            PsiType type2 = iteratedValue2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiType[] parameterTypes = classType.getParameters();
            PsiType parameterType = parameterTypes.length == 1 ? parameterTypes[0] : null;
            boolean insertCast = false;
            if (parameterType == null) {
                parameterType = TypeUtils.getObjectType((PsiElement)foreachStatement);
                insertCast = true;
            }
            PsiParameter parameter = foreachStatement.getIterationParameter();
            String variableName = KeySetIterationMapUseEntrySetFix.createNewVariableName((PsiElement)foreachStatement, parameterType);
            if (insertCast) {
                KeySetIterationMapUseEntrySetFix.replaceParameterAccess(parameter, "((Map.Entry)" + variableName + ')', map2, (PsiElement)foreachStatement);
            } else {
                KeySetIterationMapUseEntrySetFix.replaceParameterAccess(parameter, variableName, map2, (PsiElement)foreachStatement);
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            PsiParameter newParameter = factory.createParameter(variableName, parameterType);
            if (parameter.hasModifierProperty("final") && (modifierList = newParameter.getModifierList()) != null) {
                modifierList.setModifierProperty("final", true);
            }
            parameter.replace((PsiElement)newParameter);
        }

        private static void replaceParameterAccess(PsiParameter parameter, @NonNls String variableName, PsiElement map2, PsiElement context) {
            ParameterAccessCollector collector = new ParameterAccessCollector(parameter, map2);
            context.accept((PsiElementVisitor)collector);
            List<PsiExpression> accesses = collector.getParameterAccesses();
            String keyAccess = '(' + parameter.getType().getCanonicalText() + ')' + variableName + ".getKey()";
            for (PsiExpression access : accesses) {
                if (access instanceof PsiMethodCallExpression) {
                    PsiReplacementUtil.replaceExpression(access, variableName + ".getValue()");
                    continue;
                }
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)PsiReplacementUtil.replaceExpressionAndShorten(access, keyAccess);
                if (!RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)typeCastExpression)) continue;
                PsiExpression operand2 = typeCastExpression.getOperand();
                assert (operand2 != null);
                typeCastExpression.replace((PsiElement)operand2);
            }
        }

        private static String createNewVariableName(@NotNull PsiElement scope, @NotNull PsiType type2) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix", "createNewVariableName"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix", "createNewVariableName"));
            }
            Project project2 = scope.getProject();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            SuggestedNameInfo suggestions = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, type2);
            String[] names = suggestions.names;
            String baseName = names != null && names.length > 0 ? names[0] : "entry";
            if (baseName == null || baseName.isEmpty()) {
                baseName = "entry";
            }
            return codeStyleManager.suggestUniqueVariableName(baseName, scope, true);
        }

        private static class ParameterAccessCollector
        extends JavaRecursiveElementWalkingVisitor {
            private final PsiParameter parameter;
            private final PsiElement map;
            private final String parameterName;
            private final List<PsiExpression> parameterAccesses = new ArrayList<PsiExpression>();

            ParameterAccessCollector(PsiParameter parameter, PsiElement map2) {
                this.parameter = parameter;
                this.parameterName = parameter.getName();
                this.map = map2;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2.getQualifierExpression() != null) {
                    return;
                }
                String expressionText = expression2.getText();
                if (!expressionText.equals(this.parameterName)) {
                    return;
                }
                PsiElement target2 = expression2.resolve();
                if (!this.parameter.equals(target2)) {
                    return;
                }
                if (!this.collectValueUsage(expression2)) {
                    this.parameterAccesses.add((PsiExpression)expression2);
                }
            }

            private boolean collectValueUsage(PsiReferenceExpression expression2) {
                PsiElement parent = expression2.getParent();
                if (!(parent instanceof PsiExpressionList)) {
                    return false;
                }
                PsiElement grandParent = parent.getParent();
                if (!(grandParent instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!"get".equals(methodName)) {
                    return false;
                }
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement target2 = referenceExpression.resolve();
                if (!this.map.equals(target2)) {
                    return false;
                }
                PsiExpression qualifierExpression2 = referenceExpression.getQualifierExpression();
                if (qualifierExpression2 != null && !(qualifier instanceof PsiThisExpression) || qualifierExpression2 instanceof PsiSuperExpression) {
                    return false;
                }
                this.parameterAccesses.add((PsiExpression)methodCallExpression);
                return true;
            }

            List<PsiExpression> getParameterAccesses() {
                Collections.reverse(this.parameterAccesses);
                return this.parameterAccesses;
            }
        }
    }
}

