/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTemplateStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowUtils {
    private ControlFlowUtils() {
    }

    public static boolean isElseIf(PsiIfStatement ifStatement) {
        PsiElement parent = ifStatement.getParent();
        if (parent instanceof PsiCodeBlock && ((PsiCodeBlock)parent).getStatements().length == 1 && parent.getParent() instanceof PsiBlockStatement) {
            parent = parent.getParent().getParent();
        }
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement parentStatement = (PsiIfStatement)parent;
        PsiStatement elseBranch = parentStatement.getElseBranch();
        return ifStatement.equals(elseBranch);
    }

    public static boolean statementMayCompleteNormally(@Nullable PsiStatement statement2) {
        if (statement2 == null) {
            return true;
        }
        if (statement2 instanceof PsiBreakStatement || statement2 instanceof PsiContinueStatement || statement2 instanceof PsiReturnStatement || statement2 instanceof PsiThrowStatement) {
            return false;
        }
        if (statement2 instanceof PsiExpressionListStatement || statement2 instanceof PsiEmptyStatement || statement2 instanceof PsiAssertStatement || statement2 instanceof PsiDeclarationStatement || statement2 instanceof PsiSwitchLabelStatement || statement2 instanceof PsiForeachStatement) {
            return true;
        }
        if (statement2 instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return true;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return true;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return true;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return true;
            }
            String className = aClass.getQualifiedName();
            return !"java.lang.System".equals(className);
        }
        if (statement2 instanceof PsiForStatement) {
            return ControlFlowUtils.forStatementMayCompleteNormally((PsiForStatement)statement2);
        }
        if (statement2 instanceof PsiWhileStatement) {
            return ControlFlowUtils.whileStatementMayCompleteNormally((PsiWhileStatement)statement2);
        }
        if (statement2 instanceof PsiDoWhileStatement) {
            return ControlFlowUtils.doWhileStatementMayCompleteNormally((PsiDoWhileStatement)statement2);
        }
        if (statement2 instanceof PsiSynchronizedStatement) {
            PsiCodeBlock body2 = ((PsiSynchronizedStatement)statement2).getBody();
            return ControlFlowUtils.codeBlockMayCompleteNormally(body2);
        }
        if (statement2 instanceof PsiBlockStatement) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)statement2).getCodeBlock();
            return ControlFlowUtils.codeBlockMayCompleteNormally(codeBlock);
        }
        if (statement2 instanceof PsiLabeledStatement) {
            return ControlFlowUtils.labeledStatementMayCompleteNormally((PsiLabeledStatement)statement2);
        }
        if (statement2 instanceof PsiIfStatement) {
            return ControlFlowUtils.ifStatementMayCompleteNormally((PsiIfStatement)statement2);
        }
        if (statement2 instanceof PsiTryStatement) {
            return ControlFlowUtils.tryStatementMayCompleteNormally((PsiTryStatement)statement2);
        }
        if (statement2 instanceof PsiSwitchStatement) {
            return ControlFlowUtils.switchStatementMayCompleteNormally((PsiSwitchStatement)statement2);
        }
        if (statement2 instanceof PsiTemplateStatement || statement2 instanceof PsiClassLevelDeclarationStatement) {
            return true;
        }
        assert (false) : "unknown statement type: " + statement2.getClass();
        return true;
    }

    private static boolean doWhileStatementMayCompleteNormally(@NotNull PsiDoWhileStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "doWhileStatementMayCompleteNormally"));
        }
        PsiExpression condition2 = loopStatement.getCondition();
        Object value2 = ExpressionUtils.computeConstantExpression(condition2);
        PsiStatement body2 = loopStatement.getBody();
        return ControlFlowUtils.statementMayCompleteNormally(body2) && value2 != Boolean.TRUE || ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement) || ControlFlowUtils.statementContainsContinueToAncestor((PsiStatement)loopStatement);
    }

    private static boolean whileStatementMayCompleteNormally(@NotNull PsiWhileStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "whileStatementMayCompleteNormally"));
        }
        PsiExpression condition2 = loopStatement.getCondition();
        Object value2 = ExpressionUtils.computeConstantExpression(condition2);
        return value2 != Boolean.TRUE || ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement) || ControlFlowUtils.statementContainsContinueToAncestor((PsiStatement)loopStatement);
    }

    private static boolean forStatementMayCompleteNormally(@NotNull PsiForStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "forStatementMayCompleteNormally"));
        }
        if (ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement)) {
            return true;
        }
        if (ControlFlowUtils.statementContainsContinueToAncestor((PsiStatement)loopStatement)) {
            return true;
        }
        PsiExpression condition2 = loopStatement.getCondition();
        if (condition2 == null) {
            return false;
        }
        Object value2 = ExpressionUtils.computeConstantExpression(condition2);
        return Boolean.TRUE != value2;
    }

    private static boolean switchStatementMayCompleteNormally(@NotNull PsiSwitchStatement switchStatement) {
        if (switchStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "switchStatementMayCompleteNormally"));
        }
        if (ControlFlowUtils.statementIsBreakTarget((PsiStatement)switchStatement)) {
            return true;
        }
        PsiCodeBlock body2 = switchStatement.getBody();
        if (body2 == null) {
            return true;
        }
        PsiStatement[] statements = body2.getStatements();
        if (statements.length == 0) {
            return true;
        }
        int numCases = 0;
        boolean hasDefaultCase = false;
        for (PsiStatement statement2 : statements) {
            PsiBreakStatement breakStatement;
            if (statement2 instanceof PsiSwitchLabelStatement) {
                ++numCases;
                PsiSwitchLabelStatement switchLabelStatement = (PsiSwitchLabelStatement)statement2;
                if (switchLabelStatement.isDefaultCase()) {
                    hasDefaultCase = true;
                }
            }
            if (!(statement2 instanceof PsiBreakStatement) || (breakStatement = (PsiBreakStatement)statement2).getLabelIdentifier() != null) continue;
            return true;
        }
        boolean isEnum = ControlFlowUtils.isEnumSwitch(switchStatement);
        if (!hasDefaultCase && !isEnum) {
            return true;
        }
        if (!hasDefaultCase) {
            PsiExpression expression2 = switchStatement.getExpression();
            if (expression2 == null) {
                return true;
            }
            PsiClassType type2 = (PsiClassType)expression2.getType();
            if (type2 == null) {
                return true;
            }
            PsiClass aClass = type2.resolve();
            if (aClass == null) {
                return true;
            }
            PsiField[] fields = aClass.getFields();
            int numEnums = 0;
            for (PsiField field : fields) {
                PsiType fieldType = field.getType();
                if (!fieldType.equals(type2)) continue;
                ++numEnums;
            }
            if (numEnums != numCases) {
                return true;
            }
        }
        return ControlFlowUtils.statementMayCompleteNormally(statements[statements.length - 1]);
    }

    private static boolean isEnumSwitch(PsiSwitchStatement statement2) {
        PsiExpression expression2 = statement2.getExpression();
        if (expression2 == null) {
            return false;
        }
        PsiType type2 = expression2.getType();
        if (type2 == null) {
            return false;
        }
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass = ((PsiClassType)type2).resolve();
        return aClass != null && aClass.isEnum();
    }

    private static boolean tryStatementMayCompleteNormally(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock[] catchBlocks;
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "tryStatementMayCompleteNormally"));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && !ControlFlowUtils.codeBlockMayCompleteNormally(finallyBlock)) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (ControlFlowUtils.codeBlockMayCompleteNormally(tryBlock)) {
            return true;
        }
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            if (!ControlFlowUtils.codeBlockMayCompleteNormally(catchBlock)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementMayCompleteNormally(@NotNull PsiIfStatement ifStatement) {
        PsiStatement branch2;
        PsiStatement branch1;
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "ifStatementMayCompleteNormally"));
        }
        PsiExpression condition2 = ifStatement.getCondition();
        Object value2 = ExpressionUtils.computeConstantExpression(condition2);
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (value2 == Boolean.TRUE) {
            return ControlFlowUtils.statementMayCompleteNormally(thenBranch);
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (value2 == Boolean.FALSE) {
            return ControlFlowUtils.statementMayCompleteNormally(elseBranch);
        }
        if ((thenBranch == null ? 0 : thenBranch.getTextLength()) < (elseBranch == null ? 0 : elseBranch.getTextLength())) {
            branch1 = thenBranch;
            branch2 = elseBranch;
        } else {
            branch2 = thenBranch;
            branch1 = elseBranch;
        }
        return ControlFlowUtils.statementMayCompleteNormally(branch1) || ControlFlowUtils.statementMayCompleteNormally(branch2);
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull PsiLabeledStatement labeledStatement) {
        if (labeledStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labeledStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "labeledStatementMayCompleteNormally"));
        }
        PsiStatement statement2 = labeledStatement.getStatement();
        if (statement2 == null) {
            return false;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statement2) || ControlFlowUtils.statementIsBreakTarget(statement2);
    }

    public static boolean codeBlockMayCompleteNormally(@Nullable PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return true;
        }
        for (PsiStatement statement2 : statements = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement2)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementIsBreakTarget(@NotNull PsiStatement statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementIsBreakTarget"));
        }
        BreakFinder breakFinder = new BreakFinder(statement2);
        statement2.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    private static boolean statementContainsContinueToAncestor(@NotNull PsiStatement statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementContainsContinueToAncestor"));
        }
        PsiElement parent = statement2.getParent();
        while (parent instanceof PsiLabeledStatement) {
            statement2 = (PsiStatement)parent;
            parent = parent.getParent();
        }
        ContinueToAncestorFinder continueToAncestorFinder = new ContinueToAncestorFinder(statement2);
        statement2.accept((PsiElementVisitor)continueToAncestorFinder);
        return continueToAncestorFinder.continueToAncestorFound();
    }

    public static boolean containsReturn(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/ControlFlowUtils", "containsReturn"));
        }
        ReturnFinder returnFinder = new ReturnFinder();
        element.accept((PsiElementVisitor)returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull PsiStatement statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementIsContinueTarget"));
        }
        ContinueFinder continueFinder = new ContinueFinder(statement2);
        statement2.accept((PsiElementVisitor)continueFinder);
        return continueFinder.continueFound();
    }

    public static boolean containsSystemExit(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/ControlFlowUtils", "containsSystemExit"));
        }
        SystemExitFinder systemExitFinder = new SystemExitFinder();
        element.accept((PsiElementVisitor)systemExitFinder);
        return systemExitFinder.exitFound();
    }

    public static boolean elementContainsCallToMethod(PsiElement context, String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypes) {
        MethodCallFinder methodCallFinder = new MethodCallFinder(containingClassName, returnType, methodName, parameterTypes);
        context.accept((PsiElementVisitor)methodCallFinder);
        return methodCallFinder.containsCallToMethod();
    }

    public static boolean isInLoop(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInLoop"));
        }
        PsiLoopStatement loopStatement = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        if (loopStatement == null) {
            return false;
        }
        PsiStatement body2 = loopStatement.getBody();
        return body2 != null && PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)element, (boolean)true);
    }

    public static boolean isInFinallyBlock(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInFinallyBlock"));
        }
        PsiElement currentElement = element;
        PsiTryStatement tryStatement;
        while ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock != null && PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)currentElement, (boolean)true)) {
                PsiMethod elementMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiMethod.class);
                PsiMethod finallyMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)finallyBlock, PsiMethod.class);
                return elementMethod != null && elementMethod.equals(finallyMethod);
            }
            currentElement = tryStatement;
        }
        return false;
    }

    public static boolean isInCatchBlock(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInCatchBlock"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiCatchSection.class, (boolean)true, (Class[])new Class[]{PsiClass.class}) != null;
    }

    public static boolean isInExitStatement(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInExitStatement"));
        }
        return ControlFlowUtils.isInReturnStatementArgument(expression2) || ControlFlowUtils.isInThrowStatementArgument(expression2);
    }

    private static boolean isInReturnStatementArgument(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInReturnStatementArgument"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiReturnStatement.class) != null;
    }

    public static boolean isInThrowStatementArgument(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInThrowStatementArgument"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiThrowStatement.class) != null;
    }

    @Nullable
    public static PsiStatement stripBraces(@Nullable PsiStatement statement2) {
        if (statement2 instanceof PsiBlockStatement) {
            PsiBlockStatement block = (PsiBlockStatement)statement2;
            PsiStatement onlyStatement = ControlFlowUtils.getOnlyStatementInBlock(block.getCodeBlock());
            return onlyStatement != null ? onlyStatement : block;
        }
        return statement2;
    }

    public static boolean statementCompletesWithStatement(@NotNull PsiStatement containingStatement, @NotNull PsiStatement statement2) {
        if (containingStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementCompletesWithStatement"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementCompletesWithStatement"));
        }
        PsiStatement statementToCheck = statement2;
        while (!statementToCheck.equals(containingStatement)) {
            PsiElement container = ControlFlowUtils.getContainingStatementOrBlock((PsiElement)statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof PsiCodeBlock && !ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                return false;
            }
            if (container instanceof PsiLoopStatement) {
                return false;
            }
            statementToCheck = container;
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull PsiCodeBlock body2, @NotNull PsiStatement statement2) {
        if (body2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/siyeh/ig/psiutils/ControlFlowUtils", "blockCompletesWithStatement"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "blockCompletesWithStatement"));
        }
        PsiStatement statementToCheck = statement2;
        while (statementToCheck != null) {
            PsiElement container = ControlFlowUtils.getContainingStatementOrBlock((PsiElement)statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof PsiLoopStatement) {
                return false;
            }
            if (container instanceof PsiCodeBlock) {
                if (!ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body2)) {
                    return true;
                }
                statementToCheck = PsiTreeUtil.getParentOfType((PsiElement)container, PsiStatement.class);
                continue;
            }
            statementToCheck = container;
        }
        return false;
    }

    @Nullable
    private static PsiElement getContainingStatementOrBlock(@NotNull PsiElement statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "getContainingStatementOrBlock"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class});
    }

    private static boolean statementIsLastInBlock(@NotNull PsiCodeBlock block, @NotNull PsiStatement statement2) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementIsLastInBlock"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementIsLastInBlock"));
        }
        for (PsiElement child = block.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof PsiStatement)) continue;
            PsiStatement childStatement = (PsiStatement)child;
            if (statement2.equals(childStatement)) {
                return true;
            }
            if (statement2 instanceof PsiEmptyStatement) continue;
            return false;
        }
        return false;
    }

    @Nullable
    public static PsiStatement getFirstStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return (PsiStatement)PsiTreeUtil.getChildOfType((PsiElement)codeBlock, PsiStatement.class);
    }

    @Nullable
    public static PsiStatement getLastStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return ControlFlowUtils.getLastChildOfType((PsiElement)codeBlock, PsiStatement.class);
    }

    private static <T extends PsiElement> T getLastChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/ControlFlowUtils", "getLastChildOfType"));
        }
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    @Nullable
    public static PsiStatement getOnlyStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return ControlFlowUtils.getOnlyChildOfType((PsiElement)codeBlock, PsiStatement.class);
    }

    static <T extends PsiElement> T getOnlyChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/ControlFlowUtils", "getOnlyChildOfType"));
        }
        if (element == null) {
            return null;
        }
        PsiElement result2 = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child)) continue;
            if (result2 == null) {
                result2 = child;
                continue;
            }
            return null;
        }
        return (T)result2;
    }

    public static boolean hasStatementCount(@Nullable PsiCodeBlock codeBlock, int count) {
        return ControlFlowUtils.hasChildrenOfTypeCount((PsiElement)codeBlock, count, PsiStatement.class);
    }

    static <T extends PsiElement> boolean hasChildrenOfTypeCount(@Nullable PsiElement element, int count, @NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/ControlFlowUtils", "hasChildrenOfTypeCount"));
        }
        if (element == null) {
            return false;
        }
        int i2 = 0;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass.isInstance(child) || ++i2 <= count) continue;
            return false;
        }
        return i2 == count;
    }

    public static boolean isEmptyCodeBlock(PsiCodeBlock codeBlock) {
        return ControlFlowUtils.hasStatementCount(codeBlock, 0);
    }

    public static boolean methodAlwaysThrowsException(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/ControlFlowUtils", "methodAlwaysThrowsException"));
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null) {
            return true;
        }
        return !ControlFlowUtils.containsReturn((PsiElement)body2) && !ControlFlowUtils.codeBlockMayCompleteNormally(body2);
    }

    public static boolean lambdaExpressionAlwaysThrowsException(PsiLambdaExpression expression2) {
        PsiElement body2 = expression2.getBody();
        if (body2 instanceof PsiExpression) {
            return false;
        }
        if (!(body2 instanceof PsiCodeBlock)) {
            return true;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)body2;
        return !ControlFlowUtils.containsReturn((PsiElement)codeBlock) && !ControlFlowUtils.codeBlockMayCompleteNormally(codeBlock);
    }

    public static boolean statementContainsNakedBreak(PsiStatement statement2) {
        if (statement2 == null) {
            return false;
        }
        NakedBreakFinder breakFinder = new NakedBreakFinder();
        statement2.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    @Contract(value="null, _ -> false")
    public static boolean statementBreaksLoop(PsiStatement statement2, PsiLoopStatement loop) {
        if (statement2 instanceof PsiBreakStatement) {
            return ((PsiBreakStatement)statement2).findExitedStatement() == loop;
        }
        if (statement2 instanceof PsiReturnStatement) {
            PsiElement nextElement;
            PsiExpression returnValue = ((PsiReturnStatement)statement2).getReturnValue();
            PsiLoopStatement cur = loop;
            PsiElement parent = cur.getParent();
            while (true) {
                if (parent instanceof PsiLabeledStatement) {
                    cur = parent;
                } else if (parent instanceof PsiCodeBlock) {
                    PsiCodeBlock block = (PsiCodeBlock)parent;
                    PsiStatement[] statements = block.getStatements();
                    if (!(block.getParent() instanceof PsiBlockStatement) || statements.length <= 0 || statements[statements.length - 1] != cur) break;
                    cur = block.getParent();
                } else {
                    if (!(parent instanceof PsiIfStatement) || cur != ((PsiIfStatement)parent).getThenBranch() && cur != ((PsiIfStatement)parent).getElseBranch()) break;
                    cur = parent;
                }
                parent = cur.getParent();
            }
            if ((nextElement = PsiTreeUtil.skipSiblingsForward((PsiElement)cur, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class})) instanceof PsiReturnStatement) {
                return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(returnValue, ((PsiReturnStatement)nextElement).getReturnValue());
            }
            if (returnValue == null && cur.getParent() instanceof PsiCodeBlock && cur.getParent().getParent() instanceof PsiMethod && nextElement instanceof PsiJavaToken && ((PsiJavaToken)nextElement).getTokenType().equals(JavaTokenType.RBRACE)) {
                return true;
            }
        }
        return false;
    }

    private static StreamEx<PsiExpression> conditions(PsiElement element) {
        return StreamEx.iterate((Object)element, e -> e != null && !(e instanceof PsiLambdaExpression) && !(e instanceof PsiMethod), PsiElement::getParent).pairMap((child, parent) -> parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getThenBranch() == child ? parent : null).select(PsiIfStatement.class).map(PsiIfStatement::getCondition).flatMap(cond -> cond instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)cond).getOperationTokenType().equals(JavaTokenType.ANDAND) ? StreamEx.of((Object[])((PsiPolyadicExpression)cond).getOperands()) : StreamEx.of((Object)cond));
    }

    public static boolean isExecutedOnceInLoop(PsiStatement statement2, PsiLoopStatement loop) {
        if (ControlFlowUtils.flowBreaksLoop(statement2, loop)) {
            return true;
        }
        if (loop instanceof PsiForStatement) {
            boolean notWritten;
            boolean hasLoopVarCheck;
            PsiLocalVariable variable;
            PsiDeclarationStatement initialization = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)((PsiForStatement)loop).getInitialization(), PsiDeclarationStatement.class);
            PsiStatement update2 = ((PsiForStatement)loop).getUpdate();
            if (initialization != null && update2 != null && (variable = (PsiLocalVariable)StreamEx.of((Object[])initialization.getDeclaredElements()).select(PsiLocalVariable.class).findFirst(var -> VariableAccessUtils.variableIsIncremented((PsiVariable)var, update2) || VariableAccessUtils.variableIsDecremented((PsiVariable)var, update2)).orElse(null)) != null && (hasLoopVarCheck = ((StreamEx)ControlFlowUtils.conditions((PsiElement)statement2).select(PsiBinaryExpression.class).filter(binOp -> binOp.getOperationTokenType().equals(JavaTokenType.EQEQ))).anyMatch(binOp -> ExpressionUtils.getOtherOperand(binOp, (PsiVariable)variable) != null)) && (notWritten = ReferencesSearch.search((PsiElement)variable).forEach(ref -> {
                PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)ref.getElement(), PsiExpression.class);
                return expression2 == null || PsiTreeUtil.isAncestor((PsiElement)update2, (PsiElement)expression2, (boolean)false) || !PsiUtil.isAccessedForWriting((PsiExpression)expression2);
            }))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isVariableReassigned(PsiStatement statement2, PsiVariable variable) {
        PsiStatement sibling = ControlFlowUtils.nextExecutedStatement(statement2);
        while (sibling != null) {
            PsiExpression rValue = ExpressionUtils.getAssignmentTo((PsiElement)sibling, variable);
            if (rValue != null && !VariableAccessUtils.variableIsUsed(variable, (PsiElement)rValue)) {
                return true;
            }
            if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)sibling)) {
                return false;
            }
            sibling = ControlFlowUtils.nextExecutedStatement(sibling);
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean flowBreaksLoop(PsiStatement statement2, PsiLoopStatement loop) {
        if (statement2 == null || statement2 == loop) {
            return false;
        }
        PsiStatement sibling = statement2;
        while (sibling != null) {
            if (sibling instanceof PsiContinueStatement) {
                return false;
            }
            if (sibling instanceof PsiThrowStatement || sibling instanceof PsiReturnStatement) {
                return true;
            }
            if (sibling instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)sibling;
                PsiStatement exitedStatement = breakStatement.findExitedStatement();
                if (exitedStatement == loop) {
                    return true;
                }
                return ControlFlowUtils.flowBreaksLoop(ControlFlowUtils.nextExecutedStatement(exitedStatement), loop);
            }
            if ((sibling instanceof PsiIfStatement || sibling instanceof PsiSwitchStatement) && !PsiTreeUtil.collectElementsOfType((PsiElement)sibling, (Class[])new Class[]{PsiContinueStatement.class}).isEmpty()) {
                return false;
            }
            if (sibling instanceof PsiLoopStatement && PsiTreeUtil.collectElements((PsiElement)sibling, e -> e instanceof PsiContinueStatement && ((PsiContinueStatement)e).getLabelIdentifier() != null).length > 0) {
                return false;
            }
            sibling = ControlFlowUtils.nextExecutedStatement(sibling);
        }
        return false;
    }

    @Nullable
    private static PsiStatement firstStatement(@Nullable PsiStatement statement2) {
        PsiStatement[] statements;
        while (statement2 instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)statement2).getCodeBlock().getStatements()).length != 0) {
            statement2 = statements[0];
        }
        return statement2;
    }

    @Nullable
    private static PsiStatement nextExecutedStatement(PsiStatement statement2) {
        PsiStatement next = ControlFlowUtils.firstStatement((PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class));
        if (next == null) {
            PsiElement parent = statement2.getParent();
            if (parent instanceof PsiCodeBlock) {
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiBlockStatement || gParent instanceof PsiSwitchStatement) {
                    return ControlFlowUtils.nextExecutedStatement((PsiStatement)gParent);
                }
            } else if (parent instanceof PsiLabeledStatement || parent instanceof PsiIfStatement || parent instanceof PsiSwitchLabelStatement || parent instanceof PsiSwitchStatement) {
                return ControlFlowUtils.nextExecutedStatement((PsiStatement)parent);
            }
        }
        return next;
    }

    private static boolean isVariableReferencedBeforeLoopEntry(ControlFlow flow, int start, PsiLoopStatement loop, PsiVariable variable) {
        int loopStart = flow.getStartOffset((PsiElement)loop);
        int loopEnd = flow.getEndOffset((PsiElement)loop);
        if (start == loopStart) {
            return false;
        }
        List<ControlFlowUtil.ControlFlowEdge> edges = ControlFlowUtil.getEdges(flow, start);
        Collections.reverse(edges);
        BitSet referenced = new BitSet();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (ControlFlowUtil.ControlFlowEdge edge : edges) {
                int from = edge.myFrom;
                int to = edge.myTo;
                if (referenced.get(from)) {
                    if (to == loopStart && (from < loopStart || from >= loopEnd)) {
                        return true;
                    }
                    if (referenced.get(to)) continue;
                    referenced.set(to);
                    changed = true;
                    continue;
                }
                if (!ControlFlowUtil.isVariableAccess(flow, from, variable)) continue;
                referenced.set(from);
                referenced.set(to);
                if (to == loopStart) {
                    return true;
                }
                changed = true;
            }
        }
        return false;
    }

    @NotNull
    public static InitializerUsageStatus getInitializerUsageStatus(PsiVariable var, PsiLoopStatement loop) {
        ControlFlow controlFlow;
        if (!(var instanceof PsiLocalVariable) || var.getInitializer() == null) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ControlFlowUtils", "getInitializerUsageStatus"));
            }
            return initializerUsageStatus;
        }
        if (ControlFlowUtils.isDeclarationJustBefore(var, (PsiStatement)loop)) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.DECLARED_JUST_BEFORE;
            if (initializerUsageStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ControlFlowUtils", "getInitializerUsageStatus"));
            }
            return initializerUsageStatus;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)var, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class}) != PsiTreeUtil.getParentOfType((PsiElement)loop, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class})) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ControlFlowUtils", "getInitializerUsageStatus"));
            }
            return initializerUsageStatus;
        }
        PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)var, null);
        if (block == null) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ControlFlowUtils", "getInitializerUsageStatus"));
            }
            return initializerUsageStatus;
        }
        try {
            controlFlow = ControlFlowFactory.getInstance(loop.getProject()).getControlFlow(block, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException ignored) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ControlFlowUtils", "getInitializerUsageStatus"));
            }
            return initializerUsageStatus;
        }
        int start = controlFlow.getEndOffset((PsiElement)var.getInitializer()) + 1;
        int stop2 = controlFlow.getStartOffset((PsiElement)loop);
        if (ControlFlowUtils.isVariableReferencedBeforeLoopEntry(controlFlow, start, loop, var)) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ControlFlowUtils", "getInitializerUsageStatus"));
            }
            return initializerUsageStatus;
        }
        if (!ControlFlowUtil.isValueUsedWithoutVisitingStop(controlFlow, start, stop2, var)) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.AT_WANTED_PLACE_ONLY;
            if (initializerUsageStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ControlFlowUtils", "getInitializerUsageStatus"));
            }
            return initializerUsageStatus;
        }
        InitializerUsageStatus initializerUsageStatus = var.hasModifierProperty("final") ? InitializerUsageStatus.UNKNOWN : InitializerUsageStatus.AT_WANTED_PLACE;
        if (initializerUsageStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ControlFlowUtils", "getInitializerUsageStatus"));
        }
        return initializerUsageStatus;
    }

    static boolean isDeclarationJustBefore(PsiVariable var, PsiStatement nextStatement) {
        Object[] elements;
        PsiElement declaration2 = var.getParent();
        PsiElement nextStatementParent = nextStatement.getParent();
        if (nextStatementParent instanceof PsiLabeledStatement) {
            nextStatement = (PsiStatement)nextStatementParent;
        }
        return declaration2 instanceof PsiDeclarationStatement && ArrayUtil.getLastElement((Object[])(elements = ((PsiDeclarationStatement)declaration2).getDeclaredElements())) == var && nextStatement.equals(PsiTreeUtil.skipSiblingsForward((PsiElement)declaration2, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class}));
    }

    @Contract(value="null -> false")
    public static boolean statementIsEmpty(PsiStatement statement2) {
        if (statement2 == null) {
            return false;
        }
        if (statement2 instanceof PsiEmptyStatement) {
            return true;
        }
        if (statement2 instanceof PsiBlockStatement) {
            PsiStatement[] codeBlockStatements;
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            for (PsiStatement codeBlockStatement : codeBlockStatements = codeBlock.getStatements()) {
                if (ControlFlowUtils.statementIsEmpty(codeBlockStatement)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static class ContinueToAncestorFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiStatement statement;
        private boolean found;

        private ContinueToAncestorFinder(PsiStatement statement2) {
            this.statement = statement2;
        }

        public void visitElement(PsiElement element) {
            if (this.found) {
                return;
            }
            super.visitElement(element);
        }

        public void visitContinueStatement(PsiContinueStatement continueStatement) {
            if (this.found) {
                return;
            }
            super.visitContinueStatement(continueStatement);
            PsiIdentifier labelIdentifier = continueStatement.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            PsiStatement continuedStatement = continueStatement.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)continuedStatement, (PsiElement)this.statement, (boolean)true)) {
                this.found = true;
            }
        }

        private boolean continueToAncestorFound() {
            return this.found;
        }
    }

    private static class MethodCallFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final String containingClassName;
        private final PsiType returnType;
        private final String methodName;
        private final PsiType[] parameterTypeNames;
        private boolean containsCallToMethod;

        private MethodCallFinder(String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypeNames) {
            this.containingClassName = containingClassName;
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameterTypeNames = parameterTypeNames;
        }

        public void visitElement(PsiElement element) {
            if (this.containsCallToMethod) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (this.containsCallToMethod) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            if (!MethodCallUtils.isCallToMethod(expression2, this.containingClassName, this.returnType, this.methodName, this.parameterTypeNames)) {
                return;
            }
            this.containsCallToMethod = true;
        }

        private boolean containsCallToMethod() {
            return this.containsCallToMethod;
        }
    }

    private static class ContinueFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;

        private ContinueFinder(@NotNull PsiStatement target2) {
            if (target2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder", "<init>"));
            }
            this.m_target = target2;
        }

        private boolean continueFound() {
            return this.m_found;
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder", "visitContinueStatement"));
            }
            if (this.m_found) {
                return;
            }
            super.visitContinueStatement(statement2);
            PsiStatement continuedStatement = statement2.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)continuedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (this.m_found) {
                return;
            }
            PsiExpression condition2 = statement2.getCondition();
            Object value2 = ExpressionUtils.computeConstantExpression(condition2);
            if (Boolean.FALSE != value2 && (thenBranch = statement2.getThenBranch()) != null) {
                thenBranch.accept((PsiElementVisitor)this);
            }
            if (Boolean.TRUE != value2 && (elseBranch = statement2.getElseBranch()) != null) {
                elseBranch.accept((PsiElementVisitor)this);
            }
        }
    }

    private static class BreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;

        private BreakFinder(@NotNull PsiStatement target2) {
            if (target2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/siyeh/ig/psiutils/ControlFlowUtils$BreakFinder", "<init>"));
            }
            this.m_target = target2;
        }

        private boolean breakFound() {
            return this.m_found;
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils$BreakFinder", "visitBreakStatement"));
            }
            if (this.m_found) {
                return;
            }
            super.visitBreakStatement(statement2);
            PsiStatement exitedStatement = statement2.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (this.m_found) {
                return;
            }
            PsiExpression condition2 = statement2.getCondition();
            Object value2 = ExpressionUtils.computeConstantExpression(condition2);
            if (Boolean.FALSE != value2 && (thenBranch = statement2.getThenBranch()) != null) {
                thenBranch.accept((PsiElementVisitor)this);
            }
            if (Boolean.TRUE != value2 && (elseBranch = statement2.getElseBranch()) != null) {
                elseBranch.accept((PsiElementVisitor)this);
            }
        }
    }

    private static class ReturnFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myFound;

        private ReturnFinder() {
        }

        private boolean returnFound() {
            return this.myFound;
        }

        public void visitClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/siyeh/ig/psiutils/ControlFlowUtils$ReturnFinder", "visitClass"));
            }
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
            if (returnStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "com/siyeh/ig/psiutils/ControlFlowUtils$ReturnFinder", "visitReturnStatement"));
            }
            this.myFound = true;
            this.stopWalking();
        }
    }

    private static class SystemExitFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private SystemExitFinder() {
        }

        private boolean exitFound() {
            return this.m_found;
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/ControlFlowUtils$SystemExitFinder", "visitClass"));
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ControlFlowUtils$SystemExitFinder", "visitMethodCallExpression"));
            }
            if (this.m_found) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.System".equals(className) && !"java.lang.Runtime".equals(className)) {
                return;
            }
            this.m_found = true;
        }
    }

    private static class NakedBreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private NakedBreakFinder() {
        }

        private boolean breakFound() {
            return this.m_found;
        }

        public void visitElement(PsiElement element) {
            if (this.m_found) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
        }

        public void visitBreakStatement(PsiBreakStatement statement2) {
            if (statement2.getLabelIdentifier() != null) {
                return;
            }
            this.m_found = true;
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
        }

        public void visitForStatement(PsiForStatement statement2) {
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
        }

        public void visitWhileStatement(PsiWhileStatement statement2) {
        }

        public void visitSwitchStatement(PsiSwitchStatement statement2) {
        }
    }

    public static enum InitializerUsageStatus {
        DECLARED_JUST_BEFORE,
        AT_WANTED_PLACE_ONLY,
        AT_WANTED_PLACE,
        UNKNOWN;

    }
}

