/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportUtils {
    private ImportUtils() {
    }

    public static void addImportIfNeeded(@NotNull PsiClass aClass, @NotNull PsiElement context) {
        PsiElement brace;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/ImportUtils", "addImportIfNeeded"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/psiutils/ImportUtils", "addImportIfNeeded"));
        }
        PsiFile file2 = context.getContainingFile();
        if (!(file2 instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file2;
        PsiClass outerClass = aClass.getContainingClass();
        if (outerClass == null ? PsiTreeUtil.isAncestor((PsiElement)javaFile, (PsiElement)aClass, (boolean)true) : PsiTreeUtil.isAncestor((PsiElement)outerClass, (PsiElement)context, (boolean)true) && (brace = outerClass.getLBrace()) != null && brace.getTextOffset() < context.getTextOffset()) {
            return;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return;
        }
        String containingPackageName = javaFile.getPackageName();
        String packageName = ClassUtil.extractPackageName((String)qualifiedName);
        if ("java.lang".equals(packageName)) {
            return;
        }
        if (containingPackageName.equals(packageName) || importList.findSingleClassImportStatement(qualifiedName) != null) {
            return;
        }
        if (importList.findOnDemandImportStatement(packageName) != null && !ImportUtils.hasOnDemandImportConflict(qualifiedName, (PsiElement)javaFile)) {
            return;
        }
        if (ImportUtils.hasExactImportConflict(qualifiedName, javaFile)) {
            return;
        }
        Project project2 = importList.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory elementFactory = psiFacade.getElementFactory();
        PsiImportStatement importStatement = elementFactory.createImportStatement(aClass);
        importList.add((PsiElement)importStatement);
    }

    private static boolean hasAccessibleMemberWithName(@NotNull PsiClass containingClass, @NotNull String memberName, @NotNull PsiElement context) {
        PsiMethod[] methods;
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/siyeh/ig/psiutils/ImportUtils", "hasAccessibleMemberWithName"));
        }
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "com/siyeh/ig/psiutils/ImportUtils", "hasAccessibleMemberWithName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/psiutils/ImportUtils", "hasAccessibleMemberWithName"));
        }
        PsiField field = containingClass.findFieldByName(memberName, true);
        if (field != null && PsiUtil.isAccessible((PsiMember)field, (PsiElement)context, null)) {
            return true;
        }
        for (PsiMethod method : methods = containingClass.findMethodsByName(memberName, true)) {
            if (!PsiUtil.isAccessible((PsiMember)method, (PsiElement)context, null)) continue;
            return true;
        }
        PsiClass innerClass = containingClass.findInnerClassByName(memberName, true);
        return innerClass != null && PsiUtil.isAccessible((PsiMember)innerClass, (PsiElement)context, null);
    }

    public static boolean nameCanBeImported(@NotNull String fqName, @NotNull PsiElement context) {
        PsiJavaFile file2;
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "com/siyeh/ig/psiutils/ImportUtils", "nameCanBeImported"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/psiutils/ImportUtils", "nameCanBeImported"));
        }
        PsiFile containingFile = context.getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
        if (containingClass != null) {
            PsiClass[] innerClasses;
            String shortName = ClassUtil.extractClassName((String)fqName);
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper();
            if (resolveHelper.resolveAccessibleReferencedVariable(shortName, context) != null) {
                return false;
            }
            for (PsiClass innerClass : innerClasses = containingClass.getAllInnerClasses()) {
                if (innerClass.hasModifierProperty("private") && !containingClass.equals(innerClass.getContainingClass()) || innerClass.hasModifierProperty("packageLocal") && !ClassUtils.inSamePackage((PsiElement)innerClass, (PsiElement)containingClass) || !shortName.equals(innerClass.getName())) continue;
                return fqName.equals(innerClass.getQualifiedName());
            }
            while (containingClass != null) {
                if (shortName.equals(containingClass.getName())) {
                    return fqName.equals(containingClass.getQualifiedName());
                }
                containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class);
            }
        }
        if (ImportUtils.hasExactImportConflict(fqName, file2 = (PsiJavaFile)containingFile)) {
            return false;
        }
        if (ImportUtils.hasOnDemandImportConflict(fqName, (PsiElement)file2, true)) {
            return false;
        }
        if (ImportUtils.containsConflictingReference((PsiFile)file2, fqName)) {
            return false;
        }
        if (ImportUtils.containsConflictingClassName(fqName, file2)) {
            return false;
        }
        return !ImportUtils.containsConflictingTypeParameter(fqName, context);
    }

    private static boolean containsConflictingTypeParameter(String fqName, PsiElement context) {
        String shortName = ClassUtil.extractClassName((String)fqName);
        for (PsiElement parent = context.getParent(); parent != null && !(parent instanceof PsiFile); parent = parent.getParent()) {
            if (!(parent instanceof PsiTypeParameterListOwner)) continue;
            for (PsiTypeParameter parameter : ((PsiTypeParameterListOwner)parent).getTypeParameters()) {
                if (!shortName.equals(parameter.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsConflictingClassName(String fqName, PsiJavaFile file2) {
        PsiClass[] classes2;
        String shortName = ClassUtil.extractClassName((String)fqName);
        for (PsiClass aClass : classes2 = file2.getClasses()) {
            if (!shortName.equals(aClass.getName()) || fqName.equals(aClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExactImportConflict(String fqName, PsiJavaFile file2) {
        PsiImportList imports2 = file2.getImportList();
        if (imports2 == null) {
            return false;
        }
        PsiImportStatement[] importStatements = imports2.getImportStatements();
        String shortName = ClassUtil.extractClassName((String)fqName);
        String dottedShortName = '.' + shortName;
        for (PsiImportStatement importStatement : importStatements) {
            if (importStatement.isOnDemand()) continue;
            String importName = importStatement.getQualifiedName();
            if (importName == null) {
                return false;
            }
            if (importName.equals(fqName) || !importName.endsWith(dottedShortName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOnDemandImportConflict(@NotNull String fqName, @NotNull PsiElement context) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "com/siyeh/ig/psiutils/ImportUtils", "hasOnDemandImportConflict"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/psiutils/ImportUtils", "hasOnDemandImportConflict"));
        }
        return ImportUtils.hasOnDemandImportConflict(fqName, context, false);
    }

    private static boolean hasOnDemandImportConflict(@NotNull String fqName, @NotNull PsiElement context, boolean strict) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "com/siyeh/ig/psiutils/ImportUtils", "hasOnDemandImportConflict"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/psiutils/ImportUtils", "hasOnDemandImportConflict"));
        }
        PsiFile containingFile = context.getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)containingFile;
        PsiImportList imports2 = javaFile.getImportList();
        if (imports2 == null) {
            return false;
        }
        PsiImportStatementBase[] importStatements = imports2.getAllImportStatements();
        String shortName = ClassUtil.extractClassName((String)fqName);
        String packageName = ClassUtil.extractPackageName((String)fqName);
        for (PsiImportStatementBase importStatement : importStatements) {
            PsiMethod[] methods;
            String qualifiedName;
            String packageText;
            PsiJavaCodeReferenceElement importReference2;
            if (!importStatement.isOnDemand() || (importReference2 = importStatement.getImportReference()) == null || (packageText = importReference2.getText()).equals(packageName)) continue;
            PsiElement element = importReference2.resolve();
            if (element instanceof PsiPackage) {
                PsiClass[] classes2;
                PsiPackage aPackage = (PsiPackage)element;
                if (!strict) {
                    if (aPackage.findClassByShortName(shortName, containingFile.getResolveScope()).length <= 0) continue;
                    return true;
                }
                for (PsiClass aClass : classes2 = aPackage.findClassByShortName(shortName, containingFile.getResolveScope())) {
                    String qualifiedClassName = aClass.getQualifiedName();
                    if (qualifiedClassName == null || fqName.equals(qualifiedClassName)) continue;
                    return ImportUtils.containsConflictingReference(containingFile, qualifiedClassName);
                }
                continue;
            }
            if (!(element instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)element;
            PsiClass innerClass = aClass.findInnerClassByName(shortName, true);
            if (importStatement instanceof PsiImportStatement) {
                if (innerClass == null || !PsiUtil.isAccessible((PsiMember)innerClass, (PsiElement)containingFile, null) || fqName.equals(qualifiedName = innerClass.getQualifiedName()) || strict && !ImportUtils.containsConflictingReference(containingFile, qualifiedName)) continue;
                return true;
            }
            if (innerClass != null && PsiUtil.isAccessible((PsiMember)innerClass, (PsiElement)containingFile, null) && innerClass.hasModifierProperty("static") && !fqName.equals(qualifiedName = innerClass.getQualifiedName()) && (!strict || ImportUtils.memberReferenced((PsiMember)innerClass, (PsiElement)javaFile))) {
                return true;
            }
            PsiField field = aClass.findFieldByName(shortName, true);
            if (field != null && PsiUtil.isAccessible((PsiMember)field, (PsiElement)containingFile, null) && field.hasModifierProperty("static")) {
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) continue;
                String qualifiedName2 = containingClass.getQualifiedName() + '.' + field.getName();
                if (!(fqName.equals(qualifiedName2) || strict && !ImportUtils.memberReferenced((PsiMember)field, (PsiElement)javaFile))) {
                    return true;
                }
            }
            for (PsiMethod method : methods = aClass.findMethodsByName(shortName, true)) {
                String qualifiedName3;
                PsiClass containingClass;
                if (!PsiUtil.isAccessible((PsiMember)method, (PsiElement)containingFile, null) || !method.hasModifierProperty("static") || (containingClass = method.getContainingClass()) == null || fqName.equals(qualifiedName3 = containingClass.getQualifiedName() + '.' + method.getName()) || strict && !ImportUtils.memberReferenced((PsiMember)method, (PsiElement)javaFile)) continue;
                return true;
            }
        }
        return ImportUtils.hasJavaLangImportConflict(fqName, javaFile) || ImportUtils.hasDefaultImportConflict(fqName, javaFile);
    }

    private static boolean hasDefaultImportConflict(String fqName, PsiJavaFile file2) {
        String shortName = ClassUtil.extractClassName((String)fqName);
        String packageName = ClassUtil.extractPackageName((String)fqName);
        String filePackageName = file2.getPackageName();
        if (filePackageName.equals(packageName)) {
            return false;
        }
        Project project2 = file2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiPackage filePackage = psiFacade.findPackage(filePackageName);
        return filePackage != null && filePackage.containsClassNamed(shortName);
    }

    private static boolean hasJavaLangImportConflict(String fqName, PsiJavaFile file2) {
        String shortName = ClassUtil.extractClassName((String)fqName);
        String packageName = ClassUtil.extractPackageName((String)fqName);
        if ("java.lang".equals(packageName)) {
            return false;
        }
        Project project2 = file2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiPackage javaLangPackage = psiFacade.findPackage("java.lang");
        return javaLangPackage != null && javaLangPackage.containsClassNamed(shortName);
    }

    public static boolean addStaticImport(@NotNull String qualifierClass, @NonNls @NotNull String memberName, @NotNull PsiElement context) {
        PsiFile contextFile;
        if (qualifierClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierClass", "com/siyeh/ig/psiutils/ImportUtils", "addStaticImport"));
        }
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "com/siyeh/ig/psiutils/ImportUtils", "addStaticImport"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/psiutils/ImportUtils", "addStaticImport"));
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
        if (containingClass != null) {
            if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)qualifierClass)) {
                return true;
            }
            if (ImportUtils.hasAccessibleMemberWithName(containingClass, memberName, context)) {
                return false;
            }
        }
        if (!((contextFile = context.getContainingFile()) instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)contextFile;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        PsiImportStatementBase existingImportStatement = importList.findSingleImportStatement(memberName);
        if (existingImportStatement != null) {
            if (existingImportStatement instanceof PsiImportStaticStatement) {
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)existingImportStatement;
                if (!memberName.equals(importStaticStatement.getReferenceName())) {
                    return false;
                }
                PsiClass targetClass = importStaticStatement.resolveTargetClass();
                return targetClass != null && qualifierClass.equals(targetClass.getQualifiedName());
            }
            return false;
        }
        PsiImportStaticStatement onDemandImportStatement = ImportUtils.findOnDemandImportStaticStatement(importList, qualifierClass);
        if (onDemandImportStatement != null && !ImportUtils.hasOnDemandImportConflict(qualifierClass + '.' + memberName, (PsiElement)javaFile)) {
            return true;
        }
        Project project2 = context.getProject();
        GlobalSearchScope scope = context.getResolveScope();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiClass aClass = psiFacade.findClass(qualifierClass, scope);
        if (aClass == null || !PsiUtil.isAccessible((PsiMember)aClass, (PsiElement)contextFile, null) || !ImportUtils.hasAccessibleMemberWithName(aClass, memberName, (PsiElement)contextFile)) {
            return false;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        List<PsiImportStaticStatement> imports2 = ImportUtils.getMatchingImports(importList, qualifiedName);
        int onDemandCount = JavaCodeStyleSettingsFacade.getInstance((Project)project2).getNamesCountToUseImportOnDemand();
        PsiElementFactory elementFactory = psiFacade.getElementFactory();
        if (imports2.size() + 1 < onDemandCount) {
            importList.add((PsiElement)elementFactory.createImportStaticStatement(aClass, memberName));
        } else {
            for (PsiImportStaticStatement importStatement : imports2) {
                importStatement.delete();
            }
            importList.add((PsiElement)elementFactory.createImportStaticStatement(aClass, "*"));
        }
        return true;
    }

    @Nullable
    private static PsiImportStaticStatement findOnDemandImportStaticStatement(PsiImportList importList, String qualifierClass) {
        PsiImportStaticStatement[] importStaticStatements;
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements = importList.getImportStaticStatements()) {
            String text2;
            PsiJavaCodeReferenceElement importReference2;
            if (!importStaticStatement.isOnDemand() || (importReference2 = importStaticStatement.getImportReference()) == null || !qualifierClass.equals(text2 = importReference2.getText())) continue;
            return importStaticStatement;
        }
        return null;
    }

    private static List<PsiImportStaticStatement> getMatchingImports(@NotNull PsiImportList importList, @NotNull String className) {
        if (importList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importList", "com/siyeh/ig/psiutils/ImportUtils", "getMatchingImports"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/siyeh/ig/psiutils/ImportUtils", "getMatchingImports"));
        }
        ArrayList<PsiImportStaticStatement> imports2 = new ArrayList<PsiImportStaticStatement>();
        for (PsiImportStaticStatement staticStatement : importList.getImportStaticStatements()) {
            PsiClass psiClass = staticStatement.resolveTargetClass();
            if (psiClass == null || !className.equals(psiClass.getQualifiedName())) continue;
            imports2.add(staticStatement);
        }
        return imports2;
    }

    public static boolean isStaticallyImported(@NotNull PsiMember member, @NotNull PsiElement context) {
        PsiClass importClass;
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/siyeh/ig/psiutils/ImportUtils", "isStaticallyImported"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/psiutils/ImportUtils", "isStaticallyImported"));
        }
        PsiClass memberClass = member.getContainingClass();
        if (memberClass == null) {
            return false;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
            return false;
        }
        PsiFile psiFile = context.getContainingFile();
        if (!(psiFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        String memberName = member.getName();
        if (memberName == null) {
            return false;
        }
        PsiImportStatementBase existingImportStatement = importList.findSingleImportStatement(memberName);
        if (existingImportStatement instanceof PsiImportStaticStatement && InheritanceUtil.isInheritorOrSelf((PsiClass)(importClass = ((PsiImportStaticStatement)existingImportStatement).resolveTargetClass()), (PsiClass)memberClass, (boolean)true)) {
            return true;
        }
        String memberClassName = memberClass.getQualifiedName();
        if (memberClassName == null) {
            return false;
        }
        PsiImportStaticStatement onDemandImportStatement = ImportUtils.findOnDemandImportStaticStatement(importList, memberClassName);
        return onDemandImportStatement != null && !ImportUtils.hasOnDemandImportConflict(memberClassName + '.' + memberName, (PsiElement)javaFile);
    }

    private static boolean memberReferenced(PsiMember member, PsiElement context) {
        MemberReferenceVisitor visitor = new MemberReferenceVisitor(member);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isReferenceFound();
    }

    private static boolean containsConflictingReference(PsiFile element, String fullyQualifiedName) {
        Map cachedValue = (Map)CachedValuesManager.getCachedValue((PsiElement)element, () -> new CachedValueProvider.Result(Collections.synchronizedMap(new HashMap()), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        Boolean conflictingRef = (Boolean)cachedValue.get(fullyQualifiedName);
        if (conflictingRef != null) {
            return conflictingRef;
        }
        ConflictingClassReferenceVisitor visitor = new ConflictingClassReferenceVisitor(fullyQualifiedName);
        element.accept((PsiElementVisitor)visitor);
        conflictingRef = visitor.isConflictingReferenceFound();
        cachedValue.put(fullyQualifiedName, conflictingRef);
        return conflictingRef;
    }

    private static class ConflictingClassReferenceVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final String name;
        private final String fullyQualifiedName;
        private boolean referenceFound;

        ConflictingClassReferenceVisitor(String fullyQualifiedName) {
            this.name = ClassUtil.extractClassName((String)fullyQualifiedName);
            this.fullyQualifiedName = fullyQualifiedName;
        }

        public void visitElement(PsiElement element) {
            if (this.referenceFound) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (this.referenceFound) {
                return;
            }
            super.visitReferenceElement(reference);
            if (reference.getQualifier() != null) {
                return;
            }
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) {
                return;
            }
            PsiClass aClass = (PsiClass)element;
            String testClassName = aClass.getName();
            String testClassQualifiedName = aClass.getQualifiedName();
            if (testClassQualifiedName == null || testClassName == null || testClassQualifiedName.equals(this.fullyQualifiedName) || !testClassName.equals(this.name)) {
                return;
            }
            this.referenceFound = true;
        }

        boolean isConflictingReferenceFound() {
            return this.referenceFound;
        }
    }

    private static class MemberReferenceVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiMember[] members;
        private boolean referenceFound;

        MemberReferenceVisitor(PsiMember member) {
            this.members = new PsiMember[]{member};
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (this.referenceFound) {
                return;
            }
            super.visitReferenceElement(reference);
            if (reference.isQualified()) {
                return;
            }
            PsiElement target2 = reference.resolve();
            for (PsiMember member : this.members) {
                if (!member.equals(target2)) continue;
                this.referenceFound = true;
                return;
            }
        }

        boolean isReferenceFound() {
            return this.referenceFound;
        }
    }
}

