/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.MethodSignature;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InitializationUtils {
    private InitializationUtils() {
    }

    public static boolean methodAssignsVariableOrFails(@Nullable PsiMethod method, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/InitializationUtils", "methodAssignsVariableOrFails"));
        }
        return InitializationUtils.methodAssignsVariableOrFails(method, variable, false);
    }

    public static boolean expressionAssignsVariableOrFails(@Nullable PsiExpression expression2, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/InitializationUtils", "expressionAssignsVariableOrFails"));
        }
        return InitializationUtils.expressionAssignsVariableOrFails(expression2, variable, new HashSet<MethodSignature>(), true);
    }

    public static boolean methodAssignsVariableOrFails(@Nullable PsiMethod method, @NotNull PsiVariable variable, boolean strict) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/InitializationUtils", "methodAssignsVariableOrFails"));
        }
        if (method == null) {
            return false;
        }
        return InitializationUtils.blockAssignsVariableOrFails(method.getBody(), variable, strict);
    }

    public static boolean blockAssignsVariableOrFails(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/InitializationUtils", "blockAssignsVariableOrFails"));
        }
        return InitializationUtils.blockAssignsVariableOrFails(block, variable, false);
    }

    public static boolean blockAssignsVariableOrFails(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable, boolean strict) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/InitializationUtils", "blockAssignsVariableOrFails"));
        }
        return InitializationUtils.blockAssignsVariableOrFails(block, variable, new HashSet<MethodSignature>(), strict);
    }

    private static boolean blockAssignsVariableOrFails(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/InitializationUtils", "blockAssignsVariableOrFails"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/InitializationUtils", "blockAssignsVariableOrFails"));
        }
        if (block == null) {
            return false;
        }
        int assignmentCount = 0;
        for (PsiStatement statement2 : block.getStatements()) {
            if (!InitializationUtils.statementAssignsVariableOrFails(statement2, variable, checkedMethods, strict)) continue;
            if (strict) {
                ++assignmentCount;
                continue;
            }
            return true;
        }
        return assignmentCount == 1;
    }

    private static boolean statementAssignsVariableOrFails(@Nullable PsiStatement statement2, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/InitializationUtils", "statementAssignsVariableOrFails"));
        }
        if (statement2 == null) {
            return false;
        }
        if (ExceptionUtils.statementThrowsException(statement2)) {
            return true;
        }
        if (statement2 instanceof PsiBreakStatement || statement2 instanceof PsiContinueStatement || statement2 instanceof PsiAssertStatement || statement2 instanceof PsiEmptyStatement || statement2 instanceof PsiSwitchLabelStatement) {
            return false;
        }
        if (statement2 instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
            return InitializationUtils.expressionAssignsVariableOrFails(returnStatement.getReturnValue(), variable, checkedMethods, strict);
        }
        if (statement2 instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)statement2;
            return InitializationUtils.expressionAssignsVariableOrFails(throwStatement.getException(), variable, checkedMethods, strict);
        }
        if (statement2 instanceof PsiExpressionListStatement) {
            PsiExpressionListStatement list2 = (PsiExpressionListStatement)statement2;
            PsiExpressionList expressionList = list2.getExpressionList();
            for (PsiExpression expression2 : expressionList.getExpressions()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(expression2, variable, checkedMethods, strict)) continue;
                return true;
            }
            return false;
        }
        if (statement2 instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            return InitializationUtils.expressionAssignsVariableOrFails(expressionStatement.getExpression(), variable, checkedMethods, strict);
        }
        if (statement2 instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
            return InitializationUtils.declarationStatementAssignsVariableOrFails(declarationStatement, variable, checkedMethods, strict);
        }
        if (statement2 instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)statement2;
            return InitializationUtils.forStatementAssignsVariableOrFails(forStatement, variable, checkedMethods, strict);
        }
        if (statement2 instanceof PsiForeachStatement) {
            PsiForeachStatement foreachStatement = (PsiForeachStatement)statement2;
            return InitializationUtils.foreachStatementAssignsVariableOrFails(foreachStatement, variable, checkedMethods, strict);
        }
        if (statement2 instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement2;
            return InitializationUtils.whileStatementAssignsVariableOrFails(whileStatement, variable, checkedMethods, strict);
        }
        if (statement2 instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement2;
            return InitializationUtils.doWhileAssignsVariableOrFails(doWhileStatement, variable, checkedMethods, strict);
        }
        if (statement2 instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement2;
            return InitializationUtils.blockAssignsVariableOrFails(synchronizedStatement.getBody(), variable, checkedMethods, strict);
        }
        if (statement2 instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
            return InitializationUtils.blockAssignsVariableOrFails(blockStatement.getCodeBlock(), variable, checkedMethods, strict);
        }
        if (statement2 instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement2;
            return InitializationUtils.statementAssignsVariableOrFails(labeledStatement.getStatement(), variable, checkedMethods, strict);
        }
        if (statement2 instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement2;
            return InitializationUtils.ifStatementAssignsVariableOrFails(ifStatement, variable, checkedMethods, strict);
        }
        if (statement2 instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement2;
            return InitializationUtils.tryStatementAssignsVariableOrFails(tryStatement, variable, checkedMethods, strict);
        }
        if (statement2 instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement2;
            return InitializationUtils.switchStatementAssignsVariableOrFails(switchStatement, variable, checkedMethods, strict);
        }
        return false;
    }

    public static boolean switchStatementAssignsVariableOrFails(@NotNull PsiSwitchStatement switchStatement, @NotNull PsiVariable variable, boolean strict) {
        if (switchStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "com/siyeh/ig/psiutils/InitializationUtils", "switchStatementAssignsVariableOrFails"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/InitializationUtils", "switchStatementAssignsVariableOrFails"));
        }
        return InitializationUtils.switchStatementAssignsVariableOrFails(switchStatement, variable, new HashSet<MethodSignature>(), strict);
    }

    private static boolean switchStatementAssignsVariableOrFails(@NotNull PsiSwitchStatement switchStatement, @NotNull PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (switchStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "com/siyeh/ig/psiutils/InitializationUtils", "switchStatementAssignsVariableOrFails"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/InitializationUtils", "switchStatementAssignsVariableOrFails"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/InitializationUtils", "switchStatementAssignsVariableOrFails"));
        }
        PsiExpression expression2 = switchStatement.getExpression();
        if (InitializationUtils.expressionAssignsVariableOrFails(expression2, variable, checkedMethods, strict)) {
            return true;
        }
        PsiCodeBlock body2 = switchStatement.getBody();
        if (body2 == null) {
            return false;
        }
        PsiStatement[] statements = body2.getStatements();
        boolean containsDefault = false;
        boolean assigns = false;
        for (int i2 = 0; i2 < statements.length; ++i2) {
            PsiStatement statement2 = statements[i2];
            if (statement2 instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)statement2;
                if (i2 == statements.length - 1) {
                    return false;
                }
                if (labelStatement.isDefaultCase()) {
                    containsDefault = true;
                }
                assigns = false;
                continue;
            }
            if (statement2 instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)statement2;
                if (breakStatement.getLabelIdentifier() != null) {
                    return false;
                }
                if (!assigns) {
                    return false;
                }
                assigns = false;
                continue;
            }
            if (i2 != statements.length - 1 || (assigns |= InitializationUtils.statementAssignsVariableOrFails(statement2, variable, checkedMethods, strict))) continue;
            return false;
        }
        return containsDefault;
    }

    private static boolean declarationStatementAssignsVariableOrFails(PsiDeclarationStatement declarationStatement, PsiVariable variable, Set<MethodSignature> checkedMethods, boolean strict) {
        PsiElement[] elements;
        for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
            PsiVariable declaredVariable;
            if (!(element instanceof PsiVariable) || !InitializationUtils.expressionAssignsVariableOrFails((declaredVariable = (PsiVariable)element).getInitializer(), variable, checkedMethods, strict)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryStatementAssignsVariableOrFails(@NotNull PsiTryStatement tryStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiCodeBlock[] catchBlocks;
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryStatement", "com/siyeh/ig/psiutils/InitializationUtils", "tryStatementAssignsVariableOrFails"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/InitializationUtils", "tryStatementAssignsVariableOrFails"));
        }
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiResourceListElement resource : resourceList) {
                PsiExpression initializer;
                if (!(resource instanceof PsiResourceVariable) || !InitializationUtils.expressionAssignsVariableOrFails(initializer = ((PsiResourceVariable)resource).getInitializer(), variable, checkedMethods, strict)) continue;
                return true;
            }
        }
        boolean initializedInTryAndCatch = InitializationUtils.blockAssignsVariableOrFails(tryStatement.getTryBlock(), variable, checkedMethods, strict);
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            if (strict) {
                initializedInTryAndCatch &= ExceptionUtils.blockThrowsException(catchBlock);
                continue;
            }
            initializedInTryAndCatch &= InitializationUtils.blockAssignsVariableOrFails(catchBlock, variable, checkedMethods, strict);
        }
        return initializedInTryAndCatch || InitializationUtils.blockAssignsVariableOrFails(tryStatement.getFinallyBlock(), variable, checkedMethods, strict);
    }

    private static boolean ifStatementAssignsVariableOrFails(@NotNull PsiIfStatement ifStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/psiutils/InitializationUtils", "ifStatementAssignsVariableOrFails"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/InitializationUtils", "ifStatementAssignsVariableOrFails"));
        }
        PsiExpression condition2 = ifStatement.getCondition();
        if (InitializationUtils.expressionAssignsVariableOrFails(condition2, variable, checkedMethods, strict)) {
            return true;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (BoolUtils.isTrue(condition2)) {
            return InitializationUtils.statementAssignsVariableOrFails(thenBranch, variable, checkedMethods, strict);
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (BoolUtils.isFalse(condition2)) {
            return InitializationUtils.statementAssignsVariableOrFails(elseBranch, variable, checkedMethods, strict);
        }
        return InitializationUtils.statementAssignsVariableOrFails(thenBranch, variable, checkedMethods, strict) && InitializationUtils.statementAssignsVariableOrFails(elseBranch, variable, checkedMethods, strict);
    }

    private static boolean doWhileAssignsVariableOrFails(@NotNull PsiDoWhileStatement doWhileStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (doWhileStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doWhileStatement", "com/siyeh/ig/psiutils/InitializationUtils", "doWhileAssignsVariableOrFails"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/InitializationUtils", "doWhileAssignsVariableOrFails"));
        }
        return InitializationUtils.statementAssignsVariableOrFails(doWhileStatement.getBody(), variable, checkedMethods, strict) || InitializationUtils.expressionAssignsVariableOrFails(doWhileStatement.getCondition(), variable, checkedMethods, strict);
    }

    private static boolean whileStatementAssignsVariableOrFails(@NotNull PsiWhileStatement whileStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiStatement body2;
        if (whileStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whileStatement", "com/siyeh/ig/psiutils/InitializationUtils", "whileStatementAssignsVariableOrFails"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/InitializationUtils", "whileStatementAssignsVariableOrFails"));
        }
        PsiExpression condition2 = whileStatement.getCondition();
        if (InitializationUtils.expressionAssignsVariableOrFails(condition2, variable, checkedMethods, strict)) {
            return true;
        }
        return BoolUtils.isTrue(condition2) && InitializationUtils.statementAssignsVariableOrFails(body2 = whileStatement.getBody(), variable, checkedMethods, strict);
    }

    private static boolean forStatementAssignsVariableOrFails(@NotNull PsiForStatement forStatement, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (forStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "com/siyeh/ig/psiutils/InitializationUtils", "forStatementAssignsVariableOrFails"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/InitializationUtils", "forStatementAssignsVariableOrFails"));
        }
        if (InitializationUtils.statementAssignsVariableOrFails(forStatement.getInitialization(), variable, checkedMethods, strict)) {
            return true;
        }
        PsiExpression condition2 = forStatement.getCondition();
        if (InitializationUtils.expressionAssignsVariableOrFails(condition2, variable, checkedMethods, strict)) {
            return true;
        }
        if (BoolUtils.isTrue(condition2)) {
            if (InitializationUtils.statementAssignsVariableOrFails(forStatement.getBody(), variable, checkedMethods, strict)) {
                return true;
            }
            if (InitializationUtils.statementAssignsVariableOrFails(forStatement.getUpdate(), variable, checkedMethods, strict)) {
                return true;
            }
        }
        return false;
    }

    private static boolean foreachStatementAssignsVariableOrFails(@NotNull PsiForeachStatement foreachStatement, PsiVariable field, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (foreachStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreachStatement", "com/siyeh/ig/psiutils/InitializationUtils", "foreachStatementAssignsVariableOrFails"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/InitializationUtils", "foreachStatementAssignsVariableOrFails"));
        }
        return InitializationUtils.expressionAssignsVariableOrFails(foreachStatement.getIteratedValue(), field, checkedMethods, strict);
    }

    private static boolean expressionAssignsVariableOrFails(@Nullable PsiExpression expression2, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/InitializationUtils", "expressionAssignsVariableOrFails"));
        }
        if (expression2 == null) {
            return false;
        }
        if (expression2 instanceof PsiThisExpression || expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiSuperExpression || expression2 instanceof PsiClassObjectAccessExpression || expression2 instanceof PsiReferenceExpression) {
            return false;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            return InitializationUtils.expressionAssignsVariableOrFails(parenthesizedExpression.getExpression(), variable, checkedMethods, strict);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            return InitializationUtils.methodCallAssignsVariableOrFails(methodCallExpression, variable, checkedMethods, strict);
        }
        if (expression2 instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression2;
            return InitializationUtils.newExpressionAssignsVariableOrFails(newExpression, variable, checkedMethods, strict);
        }
        if (expression2 instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression array = (PsiArrayInitializerExpression)expression2;
            for (PsiExpression initializer : array.getInitializers()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(initializer, variable, checkedMethods, strict)) continue;
                return true;
            }
            return false;
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)expression2;
            return InitializationUtils.expressionAssignsVariableOrFails(typeCast.getOperand(), variable, checkedMethods, strict);
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)expression2;
            return InitializationUtils.expressionAssignsVariableOrFails(accessExpression.getArrayExpression(), variable, checkedMethods, strict) || InitializationUtils.expressionAssignsVariableOrFails(accessExpression.getIndexExpression(), variable, checkedMethods, strict);
        }
        if (expression2 instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
            return InitializationUtils.expressionAssignsVariableOrFails(prefixExpression.getOperand(), variable, checkedMethods, strict);
        }
        if (expression2 instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression2;
            return InitializationUtils.expressionAssignsVariableOrFails(postfixExpression.getOperand(), variable, checkedMethods, strict);
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            for (PsiExpression operand2 : polyadicExpression.getOperands()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(operand2, variable, checkedMethods, strict)) continue;
                return true;
            }
            return false;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression2;
            if (InitializationUtils.expressionAssignsVariableOrFails(conditional.getCondition(), variable, checkedMethods, strict)) {
                return true;
            }
            return InitializationUtils.expressionAssignsVariableOrFails(conditional.getThenExpression(), variable, checkedMethods, strict) && InitializationUtils.expressionAssignsVariableOrFails(conditional.getElseExpression(), variable, checkedMethods, strict);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiElement element;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
            PsiExpression lhs = assignment.getLExpression();
            if (InitializationUtils.expressionAssignsVariableOrFails(lhs, variable, checkedMethods, strict)) {
                return true;
            }
            if (InitializationUtils.expressionAssignsVariableOrFails(assignment.getRExpression(), variable, checkedMethods, strict)) {
                return true;
            }
            return lhs instanceof PsiReferenceExpression && variable.equals(element = ((PsiReference)lhs).resolve());
        }
        if (expression2 instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression2;
            return InitializationUtils.expressionAssignsVariableOrFails(instanceOfExpression.getOperand(), variable, checkedMethods, strict);
        }
        return false;
    }

    private static boolean newExpressionAssignsVariableOrFails(@NotNull PsiNewExpression newExpression, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/siyeh/ig/psiutils/InitializationUtils", "newExpressionAssignsVariableOrFails"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/InitializationUtils", "newExpressionAssignsVariableOrFails"));
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList != null) {
            for (PsiExpression argument : argumentList.getExpressions()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(argument, variable, checkedMethods, strict)) continue;
                return true;
            }
        }
        if (InitializationUtils.expressionAssignsVariableOrFails((PsiExpression)newExpression.getArrayInitializer(), variable, checkedMethods, strict)) {
            return true;
        }
        for (PsiExpression dimension : newExpression.getArrayDimensions()) {
            if (!InitializationUtils.expressionAssignsVariableOrFails(dimension, variable, checkedMethods, strict)) continue;
            return true;
        }
        return false;
    }

    private static boolean methodCallAssignsVariableOrFails(@NotNull PsiMethodCallExpression callExpression, PsiVariable variable, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/siyeh/ig/psiutils/InitializationUtils", "methodCallAssignsVariableOrFails"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/InitializationUtils", "methodCallAssignsVariableOrFails"));
        }
        PsiExpressionList argumentList = callExpression.getArgumentList();
        for (PsiExpression argument : argumentList.getExpressions()) {
            if (!InitializationUtils.expressionAssignsVariableOrFails(argument, variable, checkedMethods, strict)) continue;
            return true;
        }
        if (InitializationUtils.expressionAssignsVariableOrFails((PsiExpression)callExpression.getMethodExpression(), variable, checkedMethods, strict)) {
            return true;
        }
        PsiMethod method = callExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        if (!checkedMethods.add(methodSignature)) {
            return false;
        }
        PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)callExpression);
        PsiClass calledClass = method.getContainingClass();
        if (calledClass == null || !calledClass.equals(containingClass)) {
            return false;
        }
        if (method.hasModifierProperty("static") || method.hasModifierProperty("private") || method.hasModifierProperty("final") || method.isConstructor() || calledClass.hasModifierProperty("final")) {
            return InitializationUtils.blockAssignsVariableOrFails(method.getBody(), variable, checkedMethods, strict);
        }
        return false;
    }
}

