/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class IOResourceInspectionBase
extends ResourceInspection {
    protected static final String[] IO_TYPES = new String[]{"java.io.InputStream", "java.io.OutputStream", "java.io.Reader", "java.io.Writer", "java.io.RandomAccessFile", "java.util.zip.ZipFile", "java.io.Closeable"};
    final List<String> ignoredTypes = new ArrayList<String>();
    public String ignoredTypesString = "java.io.ByteArrayOutputStream,java.io.ByteArrayInputStream,java.io.StringBufferInputStream,java.io.CharArrayWriter,java.io.CharArrayReader,java.io.StringWriter,java.io.StringReader";

    public IOResourceInspectionBase() {
        IOResourceInspectionBase.parseString(this.ignoredTypesString, this.ignoredTypes);
    }

    @NotNull
    public String getID() {
        if ("IOResourceOpenedButNotSafelyClosed" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/IOResourceInspectionBase", "getID"));
        }
        return "IOResourceOpenedButNotSafelyClosed";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("i.o.resource.opened.not.closed.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/IOResourceInspectionBase", "getDisplayName"));
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/resources/IOResourceInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        IOResourceInspectionBase.parseString(this.ignoredTypesString, this.ignoredTypes);
    }

    @Override
    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/resources/IOResourceInspectionBase", "writeSettings"));
        }
        this.ignoredTypesString = IOResourceInspectionBase.formatString(this.ignoredTypes);
        super.writeSettings(element);
    }

    @Override
    public boolean isResourceCreation(PsiExpression expression2) {
        if (expression2 instanceof PsiNewExpression) {
            return TypeUtils.expressionHasTypeOrSubtype(expression2, IO_TYPES) != null && !this.isIgnoredType(expression2);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getResourceAsStream".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.Class", "java.lang.ClassLoader") == null) {
                return false;
            }
            return TypeUtils.expressionHasTypeOrSubtype(expression2, "java.io.InputStream");
        }
        return false;
    }

    private boolean isIgnoredType(PsiExpression expression2) {
        return TypeUtils.expressionHasTypeOrSubtype(expression2, this.ignoredTypes);
    }
}

