/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDBCPrepareStatementWithNonConstantStringInspection
extends BaseInspection {
    public boolean considerStaticFinalConstant = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("jdbc.prepare.statement.with.non.constant.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/JDBCPrepareStatementWithNonConstantStringInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("jdbc.prepare.statement.with.non.constant.string.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/JDBCPrepareStatementWithNonConstantStringInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("consider.static.final.fields.constant.option", new Object[0]), (InspectionProfileEntry)this, "considerStaticFinalConstant");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RuntimeExecVisitor();
    }

    private class RuntimeExecVisitor
    extends BaseInspectionVisitor {
        private RuntimeExecVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/security/JDBCPrepareStatementWithNonConstantStringInspection$RuntimeExecVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression2);
            if (!MethodCallUtils.callWithNonConstantString(expression2, JDBCPrepareStatementWithNonConstantStringInspection.this.considerStaticFinalConstant, "java.sql.Connection", "prepareStatement", "prepareCall")) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }
}

