/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InitializationUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class TransientFieldNotInitializedInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("transient.field.not.initialized.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/TransientFieldNotInitializedInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("transient.field.not.initialized.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/TransientFieldNotInitializedInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReadObjectInitializationVisitor();
    }

    private static class ReadObjectInitializationVisitor
    extends BaseInspectionVisitor {
        private ReadObjectInitializationVisitor() {
        }

        public void visitField(PsiField field) {
            super.visitField(field);
            if (!field.hasModifierProperty("transient")) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (!SerializationUtils.isSerializable(containingClass)) {
                return;
            }
            PsiExpression initializer = field.getInitializer();
            if (initializer == null && !ReadObjectInitializationVisitor.isInitializedInInitializer(field, containingClass) && !ReadObjectInitializationVisitor.isInitializedInConstructors(field, containingClass)) {
                return;
            }
            if (SerializationUtils.hasReadObject(containingClass)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private static boolean isInitializedInConstructors(@NotNull PsiField field, @NotNull PsiClass aClass) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/serialization/TransientFieldNotInitializedInspection$ReadObjectInitializationVisitor", "isInitializedInConstructors"));
            }
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/TransientFieldNotInitializedInspection$ReadObjectInitializationVisitor", "isInitializedInConstructors"));
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length == 0) {
                return false;
            }
            for (PsiMethod constructor : constructors) {
                if (InitializationUtils.methodAssignsVariableOrFails(constructor, (PsiVariable)field)) continue;
                return false;
            }
            return true;
        }

        private static boolean isInitializedInInitializer(@NotNull PsiField field, @NotNull PsiClass aClass) {
            PsiClassInitializer[] initializers;
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/serialization/TransientFieldNotInitializedInspection$ReadObjectInitializationVisitor", "isInitializedInInitializer"));
            }
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/TransientFieldNotInitializedInspection$ReadObjectInitializationVisitor", "isInitializedInInitializer"));
            }
            for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                PsiCodeBlock body2;
                if (initializer.hasModifierProperty("static") || !InitializationUtils.blockAssignsVariableOrFails(body2 = initializer.getBody(), (PsiVariable)field)) continue;
                return true;
            }
            return false;
        }
    }
}

