/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringBufferReplaceableByStringInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/StringBufferReplaceableByStringInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiElement element = (PsiElement)infos[0];
        if (element instanceof PsiNewExpression) {
            String string = InspectionGadgetsBundle.message("new.string.buffer.replaceable.by.string.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/StringBufferReplaceableByStringInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String typeText = ((PsiType)infos[1]).getPresentableText();
        String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.problem.descriptor", typeText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/StringBufferReplaceableByStringInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferReplaceableByStringVisitor();
    }

    static boolean isAppendCall(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"append".equals(methodName)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 3) {
            return arguments[0].getType() instanceof PsiArrayType && PsiType.INT.equals((Object)arguments[1].getType()) && PsiType.INT.equals((Object)arguments[2].getType());
        }
        return arguments.length == 1;
    }

    private static boolean isToStringCall(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"toString".equals(methodName)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        return arguments.length == 0;
    }

    @Nullable
    static PsiExpression getCompleteExpression(PsiElement element) {
        PsiElement parent;
        PsiElement completeExpression = element;
        boolean found = false;
        while ((parent = completeExpression.getParent()) instanceof PsiReferenceExpression) {
            PsiElement grandParent = parent.getParent();
            if (StringBufferReplaceableByStringInspectionBase.isToStringCall(grandParent)) {
                found = true;
            } else if (!StringBufferReplaceableByStringInspectionBase.isAppendCall(grandParent)) {
                return null;
            }
            completeExpression = grandParent;
            if (!found) continue;
            return (PsiExpression)completeExpression;
        }
        return null;
    }

    private static class ReplaceableByStringVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiElement myParent;
        private final PsiVariable myVariable;
        private boolean myReplaceable;
        private boolean myPossibleSideEffect;
        private boolean myToStringFound;

        ReplaceableByStringVisitor(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/style/StringBufferReplaceableByStringInspectionBase$ReplaceableByStringVisitor", "<init>"));
            }
            this.myReplaceable = true;
            this.myVariable = variable;
            this.myParent = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiIfStatement.class, PsiLoopStatement.class});
        }

        public boolean isReplaceable() {
            return this.myReplaceable && this.myToStringFound;
        }

        public void visitElement(PsiElement element) {
            if (!this.myReplaceable) {
                return;
            }
            super.visitElement(element);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            if (expression2.getTextOffset() > this.myVariable.getTextOffset() && !this.myToStringFound) {
                this.myPossibleSideEffect = true;
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression expression2) {
            super.visitPostfixExpression(expression2);
            if (expression2.getTextOffset() > this.myVariable.getTextOffset() && !this.myToStringFound) {
                this.myPossibleSideEffect = true;
            }
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            if (expression2.getTextOffset() > this.myVariable.getTextOffset() && !this.myToStringFound) {
                this.myPossibleSideEffect = true;
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (expression2.getTextOffset() < this.myVariable.getTextOffset() || this.myToStringFound) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                this.myPossibleSideEffect = true;
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                this.myPossibleSideEffect = true;
                return;
            }
            String name2 = aClass.getQualifiedName();
            if ("java.lang.StringBuffer".equals(name2) || "java.lang.StringBuilder".equals(name2)) {
                return;
            }
            if (this.isArgumentOfStringBuilderMethod(expression2)) {
                return;
            }
            this.myPossibleSideEffect = true;
        }

        private boolean isArgumentOfStringBuilderMethod(PsiMethodCallExpression expression2) {
            PsiExpressionList parent = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpressionList.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
            if (parent == null) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                if (!this.isCallToStringBuilderMethod(methodCallExpression)) {
                    return this.isArgumentOfStringBuilderMethod(methodCallExpression);
                }
                return true;
            }
            if (grandParent instanceof PsiNewExpression) {
                PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)grandParent, PsiLocalVariable.class, (boolean)true, (Class[])new Class[]{PsiExpressionList.class});
                if (!this.myVariable.equals(variable)) {
                    return false;
                }
                PsiNewExpression newExpression = (PsiNewExpression)grandParent;
                PsiMethod constructor = newExpression.resolveMethod();
                if (constructor == null) {
                    return false;
                }
                PsiClass aClass = constructor.getContainingClass();
                if (aClass == null) {
                    return false;
                }
                String name2 = aClass.getQualifiedName();
                return "java.lang.StringBuffer".equals(name2) || "java.lang.StringBuilder".equals(name2);
            }
            return false;
        }

        private boolean isCallToStringBuilderMethod(PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            while (qualifier instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)qualifier;
                PsiReferenceExpression methodExpression1 = callExpression.getMethodExpression();
                qualifier = methodExpression1.getQualifierExpression();
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target2 = referenceExpression.resolve();
            if (!this.myVariable.equals(target2)) {
                return false;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String name1 = aClass.getQualifiedName();
            return "java.lang.StringBuffer".equals(name1) || "java.lang.StringBuilder".equals(name1);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            PsiElement grandParent;
            if (!this.myReplaceable || expression2.getTextOffset() < this.myVariable.getTextOffset()) {
                return;
            }
            super.visitReferenceExpression(expression2);
            PsiExpression qualifier = expression2.getQualifierExpression();
            if (qualifier != null) {
                return;
            }
            PsiElement target2 = expression2.resolve();
            if (!this.myVariable.equals(target2)) {
                return;
            }
            if (this.myToStringFound) {
                this.myReplaceable = false;
                return;
            }
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{PsiCodeBlock.class, PsiIfStatement.class, PsiLoopStatement.class});
            if (!this.myParent.equals(element)) {
                this.myReplaceable = false;
                return;
            }
            PsiElement parent = expression2.getParent();
            do {
                if (!(parent instanceof PsiReferenceExpression)) {
                    this.myReplaceable = false;
                    return;
                }
                grandParent = parent.getParent();
                if (!StringBufferReplaceableByStringInspectionBase.isAppendCall(grandParent)) {
                    if (!StringBufferReplaceableByStringInspectionBase.isToStringCall(grandParent)) {
                        this.myReplaceable = false;
                        return;
                    }
                    this.myToStringFound = true;
                    return;
                }
                if (!this.myPossibleSideEffect) continue;
                this.myReplaceable = false;
                return;
            } while (!((parent = grandParent.getParent()) instanceof PsiExpressionStatement));
        }
    }

    private static class StringBufferReplaceableByStringVisitor
    extends BaseInspectionVisitor {
        private StringBufferReplaceableByStringVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/style/StringBufferReplaceableByStringInspectionBase$StringBufferReplaceableByStringVisitor", "visitLocalVariable"));
            }
            super.visitLocalVariable(variable);
            PsiType type2 = variable.getType();
            if (!TypeUtils.typeEquals("java.lang.StringBuffer", type2) && !TypeUtils.typeEquals("java.lang.StringBuilder", type2)) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (!StringBufferReplaceableByStringVisitor.isNewStringBufferOrStringBuilder(initializer)) {
                return;
            }
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (codeBlock == null) {
                return;
            }
            ReplaceableByStringVisitor visitor = new ReplaceableByStringVisitor((PsiVariable)variable);
            codeBlock.accept((PsiElementVisitor)visitor);
            if (!visitor.isReplaceable()) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, variable, type2);
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!TypeUtils.typeEquals("java.lang.StringBuffer", type2) && !TypeUtils.typeEquals("java.lang.StringBuilder", type2)) {
                return;
            }
            PsiExpression completeExpression = StringBufferReplaceableByStringInspectionBase.getCompleteExpression((PsiElement)expression2);
            if (completeExpression == null) {
                return;
            }
            this.registerNewExpressionError(expression2, expression2, type2);
        }

        private static boolean isNewStringBufferOrStringBuilder(PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            if (expression2 instanceof PsiNewExpression) {
                return true;
            }
            if (!StringBufferReplaceableByStringInspectionBase.isAppendCall((PsiElement)expression2) || !(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return StringBufferReplaceableByStringVisitor.isNewStringBufferOrStringBuilder(qualifier);
        }
    }
}

