/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryQualifierForThisInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message(infos[0] instanceof PsiThisExpression ? "unnecessary.qualifier.for.this.problem.descriptor" : "unnecessary.qualifier.for.super.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryQualifierForThisVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryQualifierForThisFix();
    }

    private static class UnnecessaryQualifierForThisVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryQualifierForThisVisitor() {
        }

        public void visitThisExpression(@NotNull PsiThisExpression thisExpression) {
            if (thisExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisExpression", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisVisitor", "visitThisExpression"));
            }
            super.visitThisExpression(thisExpression);
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement referent = qualifier.resolve();
            if (!(referent instanceof PsiClass)) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)thisExpression);
            if (containingClass == null || !containingClass.equals(referent)) {
                return;
            }
            this.registerError((PsiElement)qualifier, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{thisExpression});
        }

        public void visitSuperExpression(PsiSuperExpression expression2) {
            super.visitSuperExpression(expression2);
            PsiJavaCodeReferenceElement qualifier = expression2.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement resolve2 = qualifier.resolve();
            if (!(resolve2 instanceof PsiClass)) {
                return;
            }
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiReferenceExpression) {
                PsiElement gParent = parent.getParent();
                PsiReferenceExpression copy = gParent instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)gParent.copy()).getMethodExpression() : (PsiReferenceExpression)parent.copy();
                PsiExpression copyQualifierExpression = copy.getQualifierExpression();
                assert (copyQualifierExpression != null);
                PsiReplacementUtil.replaceExpression(copyQualifierExpression, "super");
                if (copy.resolve() == ((PsiReferenceExpression)parent).resolve()) {
                    this.registerError((PsiElement)qualifier, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{expression2});
                }
            }
        }
    }

    private static class UnnecessaryQualifierForThisFix
    extends InspectionGadgetsFix {
        private UnnecessaryQualifierForThisFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement qualifier = descriptor.getPsiElement();
            PsiElement parent = qualifier.getParent();
            if (parent instanceof PsiThisExpression) {
                PsiReplacementUtil.replaceExpression((PsiExpression)((PsiThisExpression)parent), "this");
            } else if (parent instanceof PsiSuperExpression) {
                PsiReplacementUtil.replaceExpression((PsiExpression)((PsiSuperExpression)parent), "super");
            }
        }
    }
}

