/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodMayBeSynchronizedInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.may.be.synchronized.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/MethodMayBeSynchronizedInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.may.be.synchronized.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/MethodMayBeSynchronizedInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MethodMayBeSynchronizedQuickFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodMayBeSynchronizedVisitor();
    }

    private static class MethodMayBeSynchronizedVisitor
    extends BaseInspectionVisitor {
        private MethodMayBeSynchronizedVisitor() {
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement2) {
            super.visitSynchronizedStatement(statement2);
            PsiElement parent = statement2.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)grandParent;
            if (!ControlFlowUtils.hasStatementCount(method.getBody(), 1)) {
                return;
            }
            PsiExpression lockExpression2 = statement2.getLockExpression();
            if (method.hasModifierProperty("static")) {
                PsiClass containingClass;
                if (!(lockExpression2 instanceof PsiClassObjectAccessExpression)) {
                    return;
                }
                PsiClassObjectAccessExpression classExpression = (PsiClassObjectAccessExpression)lockExpression2;
                PsiTypeElement typeElement = classExpression.getOperand();
                PsiType type2 = typeElement.getType();
                if (!(type2 instanceof PsiClassType)) {
                    return;
                }
                PsiClassType classType = (PsiClassType)type2;
                PsiClass aClass = classType.resolve();
                if (aClass != (containingClass = method.getContainingClass())) {
                    return;
                }
                this.registerMethodError(method, new Object[0]);
            } else {
                if (!(lockExpression2 instanceof PsiThisExpression)) {
                    return;
                }
                PsiThisExpression thisExpression = (PsiThisExpression)lockExpression2;
                PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
                if (qualifier != null) {
                    PsiElement target2 = qualifier.resolve();
                    PsiClass containingClass = method.getContainingClass();
                    if (!containingClass.equals(target2)) {
                        return;
                    }
                }
                this.registerMethodError(method, new Object[0]);
            }
        }
    }

    private static class MethodMayBeSynchronizedQuickFix
    extends InspectionGadgetsFix {
        private MethodMayBeSynchronizedQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("method.may.be.synchronized.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/MethodMayBeSynchronizedInspection$MethodMayBeSynchronizedQuickFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement identifier = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)identifier.getParent();
            PsiCodeBlock methodBody2 = method.getBody();
            PsiStatement statement2 = ControlFlowUtils.getOnlyStatementInBlock(methodBody2);
            if (!(statement2 instanceof PsiSynchronizedStatement)) {
                return;
            }
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement2;
            PsiCodeBlock body2 = synchronizedStatement.getBody();
            if (body2 == null) {
                return;
            }
            PsiStatement[] statements = body2.getStatements();
            if (statements.length > 0) {
                PsiElement added = methodBody2.addRangeBefore((PsiElement)statements[0], (PsiElement)statements[statements.length - 1], (PsiElement)synchronizedStatement);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
                codeStyleManager.reformat(added);
            }
            synchronizedStatement.delete();
            PsiModifierList modifierList = method.getModifierList();
            modifierList.setModifierProperty("synchronized", true);
        }
    }
}

