/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SynchronizationUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonAtomicOperationOnVolatileFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.atomic.operation.on.volatile.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/NonAtomicOperationOnVolatileFieldInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.atomic.operation.on.volatile.field.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/NonAtomicOperationOnVolatileFieldInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonAtomicOperationOnVolatileFieldVisitor();
    }

    private static class NonAtomicOperationOnVolatileFieldVisitor
    extends BaseInspectionVisitor {
        private NonAtomicOperationOnVolatileFieldVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/NonAtomicOperationOnVolatileFieldInspection$NonAtomicOperationOnVolatileFieldVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(expression2);
            PsiExpression rhs = expression2.getRExpression();
            if (rhs == null) {
                return;
            }
            PsiExpression lhs = expression2.getLExpression();
            PsiField volatileField = NonAtomicOperationOnVolatileFieldVisitor.findNonSynchronizedVolatileField(lhs);
            if (volatileField == null) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSEQ) || tokenType.equals(JavaTokenType.MINUSEQ) || tokenType.equals(JavaTokenType.ASTERISKEQ) || tokenType.equals(JavaTokenType.DIVEQ) || tokenType.equals(JavaTokenType.ANDEQ) || tokenType.equals(JavaTokenType.OREQ) || tokenType.equals(JavaTokenType.XOREQ) || tokenType.equals(JavaTokenType.PERCEQ) || tokenType.equals(JavaTokenType.LTLTEQ) || tokenType.equals(JavaTokenType.GTGTEQ) || tokenType.equals(JavaTokenType.GTGTGTEQ)) {
                this.registerError((PsiElement)lhs, new Object[0]);
                return;
            }
            if (VariableAccessUtils.variableIsUsed((PsiVariable)volatileField, (PsiElement)rhs)) {
                this.registerError((PsiElement)lhs, new Object[0]);
            }
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.PLUS.equals(tokenType) || JavaTokenType.MINUS.equals(tokenType) || JavaTokenType.EXCL.equals(tokenType)) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiField volatileField = NonAtomicOperationOnVolatileFieldVisitor.findNonSynchronizedVolatileField(operand2);
            if (volatileField == null) {
                return;
            }
            this.registerError((PsiElement)operand2, new Object[0]);
        }

        public void visitPostfixExpression(PsiPostfixExpression expression2) {
            super.visitPostfixExpression(expression2);
            PsiExpression operand2 = expression2.getOperand();
            PsiField volatileField = NonAtomicOperationOnVolatileFieldVisitor.findNonSynchronizedVolatileField(operand2);
            if (volatileField == null) {
                return;
            }
            this.registerError((PsiElement)operand2, new Object[0]);
        }

        @Nullable
        private static PsiField findNonSynchronizedVolatileField(PsiExpression expression2) {
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)expression2;
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)referent;
            if (!field.hasModifierProperty("volatile")) {
                return null;
            }
            if (SynchronizationUtil.isInSynchronizedContext((PsiElement)reference)) {
                return null;
            }
            return field;
        }
    }
}

