/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SynchronizeOnLockInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("SynchroniziationOnLockObject" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizeOnLockInspection", "getID"));
        }
        return "SynchroniziationOnLockObject";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronize.on.lock.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizeOnLockInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String type2 = (String)infos[0];
        String string = InspectionGadgetsBundle.message("synchronize.on.lock.problem.descriptor", type2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizeOnLockInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnLockVisitor();
    }

    private static class SynchronizeOnLockVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnLockVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/SynchronizeOnLockInspection$SynchronizeOnLockVisitor", "visitSynchronizedStatement"));
            }
            super.visitSynchronizedStatement(statement2);
            PsiExpression lockExpression2 = statement2.getLockExpression();
            if (lockExpression2 == null) {
                return;
            }
            String type2 = TypeUtils.expressionHasTypeOrSubtype(lockExpression2, "java.util.concurrent.locks.Lock", "java.util.concurrent.locks.ReadWriteLock");
            if (type2 == null) {
                return;
            }
            this.registerError((PsiElement)lockExpression2, type2);
        }
    }
}

