/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MethodOverridesInaccessibleMethodOfSuperInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.overrides.inaccessible.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/MethodOverridesInaccessibleMethodOfSuperInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message(infos[0].equals("packageLocal") ? "method.overrides.package.local.method.problem.descriptor" : "method.overrides.private.display.name.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/MethodOverridesInaccessibleMethodOfSuperInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOverridesPrivateMethodVisitor();
    }

    private static class MethodOverridesPrivateMethodVisitor
    extends BaseInspectionVisitor {
        private MethodOverridesPrivateMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/visibility/MethodOverridesInaccessibleMethodOfSuperInspection$MethodOverridesPrivateMethodVisitor", "visitMethod"));
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (JavaHighlightUtil.isSerializationRelatedMethod(method, aClass)) {
                return;
            }
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            for (PsiClass ancestorClass = aClass.getSuperClass(); ancestorClass != null && visitedClasses.add(ancestorClass); ancestorClass = ancestorClass.getSuperClass()) {
                PsiSubstitutor classSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)ancestorClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                PsiMethod overridingMethod = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived((PsiClass)aClass, (PsiClass)ancestorClass, (MethodSignature)method.getSignature(classSubstitutor), (boolean)false);
                if (overridingMethod == null) continue;
                if (overridingMethod.hasModifierProperty("packageLocal")) {
                    String ancestorPackageName;
                    PsiJavaFile ancestorFile;
                    PsiJavaFile file2 = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiJavaFile.class);
                    if (file2 == null || (ancestorFile = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)ancestorClass, PsiJavaFile.class)) == null) break;
                    String packageName = file2.getPackageName();
                    if (packageName.equals(ancestorPackageName = ancestorFile.getPackageName())) continue;
                    this.registerMethodError(method, "packageLocal");
                    break;
                }
                if (!overridingMethod.hasModifierProperty("private")) continue;
                this.registerMethodError(method, "private");
                break;
            }
        }
    }
}

