/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.collections;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithArraysAsListIntention
extends MutablyNamedIntention {
    private String replacementText = null;

    @Override
    protected String getTextForElement(PsiElement element) {
        return IntentionPowerPackBundle.message("replace.with.arrays.as.list.intention.name", this.replacementText);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = e -> {
            if (!(e instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)e;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.equals("java.util.Collections")) {
                return false;
            }
            String name2 = method.getName();
            this.replacementText = ReplaceWithArraysAsListIntention.getReplacementMethodText(name2, e);
            return this.replacementText != null;
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/collections/ReplaceWithArraysAsListIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/collections/ReplaceWithArraysAsListIntention", "processIntention"));
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, this.replacementText + argumentList.getText());
    }

    private static String getReplacementMethodText(String methodName, PsiElement context) {
        if (methodName.equals("emptyList") || methodName.equals("singletonList")) {
            if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)context)) {
                return "java.util.List.of";
            }
            if (ClassUtils.findClass("com.google.common.collect.ImmutableList", context) != null) {
                return "com.google.common.collect.ImmutableList.of";
            }
            return "java.util.Arrays.asList";
        }
        if (methodName.equals("emptySet") || methodName.equals("singleton")) {
            if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)context)) {
                return "java.util.Set.of";
            }
            if (ClassUtils.findClass("com.google.common.collect.ImmutableSet", context) != null) {
                return "com.google.common.collect.ImmutableSet.of";
            }
        } else if (methodName.equals("emptyMap") || methodName.equals("singletonMap")) {
            if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)context)) {
                return "java.util.Map.of";
            }
            if (ClassUtils.findClass("com.google.common.collect.ImmutableMap", context) != null) {
                return "com.google.common.collect.ImmutableMap.of";
            }
        }
        return null;
    }
}

