/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.comment.EndOfLineCommentPredicate;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ChangeToCStyleCommentIntention
extends Intention {
    private static final Class<PsiWhiteSpace>[] WHITESPACE_CLASS = new Class[]{PsiWhiteSpace.class};

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        EndOfLineCommentPredicate endOfLineCommentPredicate = new EndOfLineCommentPredicate();
        if (endOfLineCommentPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/comment/ChangeToCStyleCommentIntention", "getElementPredicate"));
        }
        return endOfLineCommentPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        String newCommentString;
        CharSequence text2;
        PsiElement prevComment;
        PsiComment firstComment = (PsiComment)element;
        while (ChangeToCStyleCommentIntention.isEndOfLineComment(prevComment = PsiTreeUtil.skipSiblingsBackward((PsiElement)firstComment, (Class[])WHITESPACE_CLASS))) {
            assert (prevComment != null);
            firstComment = (PsiComment)prevComment;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        ArrayList<PsiComment> multiLineComments = new ArrayList<PsiComment>();
        PsiComment nextComment = firstComment;
        String whiteSpace = null;
        while (ChangeToCStyleCommentIntention.isEndOfLineComment((PsiElement)(nextComment = PsiTreeUtil.skipSiblingsForward((PsiElement)nextComment, (Class[])WHITESPACE_CLASS)))) {
            assert (nextComment != null);
            if (whiteSpace == null) {
                PsiElement prevSibling = nextComment.getPrevSibling();
                assert (prevSibling != null);
                text2 = prevSibling.getText();
                whiteSpace = ChangeToCStyleCommentIntention.getIndent((String)text2);
            }
            multiLineComments.add(nextComment);
        }
        if (multiLineComments.isEmpty()) {
            String text22 = ChangeToCStyleCommentIntention.getCommentContents(firstComment);
            newCommentString = "/* " + text22 + " */";
        } else {
            text2 = new StringBuilder();
            ((StringBuilder)text2).append("/*\n");
            ((StringBuilder)text2).append(whiteSpace);
            ((StringBuilder)text2).append(ChangeToCStyleCommentIntention.getCommentContents(firstComment));
            for (PsiComment psiComment : multiLineComments) {
                ((StringBuilder)text2).append('\n');
                ((StringBuilder)text2).append(whiteSpace);
                ((StringBuilder)text2).append(ChangeToCStyleCommentIntention.getCommentContents(psiComment));
            }
            ((StringBuilder)text2).append('\n');
            ((StringBuilder)text2).append(whiteSpace);
            ((StringBuilder)text2).append("*/");
            newCommentString = ((StringBuilder)text2).toString();
        }
        PsiComment newComment = factory.createCommentFromText(newCommentString, element);
        firstComment.replace((PsiElement)newComment);
        for (PsiElement psiElement : multiLineComments) {
            psiElement.delete();
        }
    }

    private static String getIndent(String whitespace) {
        for (int i2 = whitespace.length() - 1; i2 >= 0; --i2) {
            char c = whitespace.charAt(i2);
            if (c != '\n') continue;
            if (i2 == whitespace.length() - 1) {
                return "";
            }
            return whitespace.substring(i2 + 1);
        }
        return whitespace;
    }

    private static boolean isEndOfLineComment(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        IElementType tokenType = comment.getTokenType();
        return JavaTokenType.END_OF_LINE_COMMENT.equals(tokenType);
    }

    private static String getCommentContents(@NotNull PsiComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/siyeh/ipp/comment/ChangeToCStyleCommentIntention", "getCommentContents"));
        }
        String text2 = comment.getText();
        return StringUtil.replace((String)text2.substring(2), (String)"*/", (String)"* /").trim();
    }
}

