/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.SimpleStringConcatenationPredicate;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public class CopyConcatenatedStringToClipboardIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        SimpleStringConcatenationPredicate simpleStringConcatenationPredicate = new SimpleStringConcatenationPredicate(false);
        if (simpleStringConcatenationPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/concatenation/CopyConcatenatedStringToClipboardIntention", "getElementPredicate"));
        }
        return simpleStringConcatenationPredicate;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/concatenation/CopyConcatenatedStringToClipboardIntention", "processIntention"));
        }
        if (!(element instanceof PsiPolyadicExpression)) {
            return;
        }
        PsiPolyadicExpression concatenationExpression = (PsiPolyadicExpression)element;
        IElementType tokenType = concatenationExpression.getOperationTokenType();
        if (tokenType != JavaTokenType.PLUS) {
            return;
        }
        PsiType type2 = concatenationExpression.getType();
        if (type2 == null || !type2.equalsToText("java.lang.String")) {
            return;
        }
        StringBuilder text2 = CopyConcatenatedStringToClipboardIntention.buildConcatenationText(concatenationExpression, new StringBuilder());
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2.toString()));
    }

    private static StringBuilder buildConcatenationText(PsiPolyadicExpression polyadicExpression, StringBuilder out) {
        for (PsiElement element : polyadicExpression.getChildren()) {
            if (element instanceof PsiExpression) {
                PsiExpression expression2 = (PsiExpression)element;
                Object value2 = ExpressionUtils.computeConstantExpression(expression2);
                if (value2 == null) {
                    out.append('?');
                    continue;
                }
                out.append(value2.toString());
                continue;
            }
            if (!(element instanceof PsiWhiteSpace) || !element.getText().contains("\n") || out.length() != 0 && out.charAt(out.length() - 1) == '\n') continue;
            out.append('\n');
        }
        return out;
    }
}

