/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.Nullable;

class MethodCallChainPredicate
implements PsiElementPredicate {
    MethodCallChainPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!MethodCallChainPredicate.isCallChain(element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiExpressionStatement) {
            return true;
        }
        if (parent instanceof PsiLocalVariable) {
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)grandParent;
            return declarationStatement.getDeclaredElements().length == 1;
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiElement grandParent = parent.getParent();
            return grandParent instanceof PsiExpressionStatement;
        }
        return false;
    }

    private static boolean isCallChain(PsiElement element) {
        PsiClassType aClassType1 = MethodCallChainPredicate.getQualifierExpressionType(element);
        if (aClassType1 == null) {
            return false;
        }
        boolean first = true;
        while (true) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            PsiClassType expressionType = MethodCallChainPredicate.getQualifierExpressionType((PsiElement)qualifierExpression2);
            if (!first) {
                if (expressionType == null) {
                    return !(qualifierExpression2 instanceof PsiMethodCallExpression) || ((PsiMethodCallExpression)qualifierExpression2).getMethodExpression().getQualifierExpression() != null;
                }
            } else {
                first = false;
            }
            if (!aClassType1.equals((Object)expressionType)) {
                return false;
            }
            aClassType1 = expressionType;
            element = qualifierExpression2;
        }
    }

    @Nullable
    private static PsiClassType getQualifierExpressionType(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
        PsiType type2 = qualifierExpression2 != null ? qualifierExpression2.getType() : null;
        return type2 instanceof PsiClassType ? (PsiClassType)type2 : null;
    }
}

