/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.SimpleStringConcatenationPredicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceConcatenationWithStringBufferIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
            return IntentionPowerPackBundle.message("replace.concatenation.with.string.builder.intention.name", new Object[0]);
        }
        return IntentionPowerPackBundle.message("replace.concatenation.with.string.buffer.intention.name", new Object[0]);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        SimpleStringConcatenationPredicate simpleStringConcatenationPredicate = new SimpleStringConcatenationPredicate(true);
        if (simpleStringConcatenationPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/concatenation/ReplaceConcatenationWithStringBufferIntention", "getElementPredicate"));
        }
        return simpleStringConcatenationPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/concatenation/ReplaceConcatenationWithStringBufferIntention", "processIntention"));
        }
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)element;
        PsiElement parent = expression2.getParent();
        while (ExpressionUtils.isConcatenation(parent)) {
            expression2 = (PsiPolyadicExpression)parent;
            parent = expression2.getParent();
        }
        StringBuilder newExpression = new StringBuilder();
        if (ReplaceConcatenationWithStringBufferIntention.isPartOfStringBufferAppend((PsiExpression)expression2)) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent.getParent();
            assert (methodCallExpression != null);
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 != null) {
                String qualifierText = qualifierExpression2.getText();
                newExpression.append(qualifierText);
            }
            ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends((PsiExpression)expression2, newExpression);
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression.toString());
        } else {
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression2)) {
                newExpression.append("new StringBuffer()");
            } else {
                newExpression.append("new StringBuilder()");
            }
            ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends((PsiExpression)expression2, newExpression);
            newExpression.append(".toString()");
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression.toString());
        }
    }

    private static boolean isPartOfStringBufferAppend(PsiExpression expression2) {
        PsiElement parent = expression2.getParent();
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        if (!((parent = parent.getParent()) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        PsiType type2 = methodExpression.getType();
        if (type2 == null) {
            return false;
        }
        String className = type2.getCanonicalText();
        if (!"java.lang.StringBuffer".equals(className) && !"java.lang.StringBuilder".equals(className)) {
            return false;
        }
        String methodName = methodExpression.getReferenceName();
        return "append".equals(methodName);
    }

    private static void turnExpressionIntoChainedAppends(PsiExpression expression2, @NonNls StringBuilder result2) {
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression concatenation = (PsiPolyadicExpression)expression2;
            PsiType type2 = concatenation.getType();
            if (type2 != null && !type2.equalsToText("java.lang.String")) {
                result2.append(".append(").append(concatenation.getText()).append(')');
                return;
            }
            PsiExpression[] operands2 = concatenation.getOperands();
            PsiType startType = operands2[0].getType();
            if (startType == null || startType.equalsToText("java.lang.String")) {
                for (PsiExpression operand2 : operands2) {
                    ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(operand2, result2);
                }
                return;
            }
            StringBuilder newExpressionText = new StringBuilder(operands2[0].getText());
            boolean string = false;
            for (int i2 = 1; i2 < operands2.length; ++i2) {
                PsiExpression operand3 = operands2[i2];
                if (!string) {
                    PsiType operandType = operand3.getType();
                    if (operandType == null || operandType.equalsToText("java.lang.String")) {
                        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
                        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText.toString(), (PsiElement)expression2);
                        ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(newExpression, result2);
                        ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(operand3, result2);
                        string = true;
                    }
                    newExpressionText.append('+').append(operand3.getText());
                    continue;
                }
                ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(operand3, result2);
            }
        } else {
            PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression2);
            result2.append(".append(");
            if (strippedExpression != null) {
                result2.append(strippedExpression.getText());
            }
            result2.append(')');
        }
    }
}

