/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.constant;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.constant.ConstantExpressionPredicate;
import com.siyeh.ipp.psiutils.HighlightUtil;
import org.jetbrains.annotations.NotNull;

public class ConstantExpressionIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        String text2 = HighlightUtil.getPresentableText(element);
        return IntentionPowerPackBundle.message("constant.expression.intention.name", text2);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ConstantExpressionPredicate constantExpressionPredicate = new ConstantExpressionPredicate();
        if (constantExpressionPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/constant/ConstantExpressionIntention", "getElementPredicate"));
        }
        return constantExpressionPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        String newExpression;
        PsiExpression expression2 = (PsiExpression)element;
        Object value2 = ExpressionUtils.computeConstantExpression(expression2);
        if (value2 instanceof String) {
            String string = (String)value2;
            newExpression = '\"' + StringUtil.escapeStringCharacters((String)string) + '\"';
        } else {
            double v;
            newExpression = value2 instanceof Character ? '\'' + StringUtil.escapeStringCharacters((String)value2.toString()) + '\'' : (value2 instanceof Long ? value2.toString() + 'L' : (value2 instanceof Double ? (Double.isNaN(v = ((Double)value2).doubleValue()) ? "java.lang.Double.NaN" : (Double.isInfinite(v) ? (v > 0.0 ? "java.lang.Double.POSITIVE_INFINITY" : "java.lang.Double.NEGATIVE_INFINITY") : Double.toString(v))) : (value2 instanceof Float ? (Float.isNaN(v = ((Float)value2).floatValue()) ? "java.lang.Float.NaN" : (Float.isInfinite(v) ? (v > 0.0f ? "java.lang.Float.POSITIVE_INFINITY" : "java.lang.Float.NEGATIVE_INFINITY") : Float.toString(v) + 'f')) : (value2 == null ? "null" : String.valueOf(value2)))));
        }
        PsiReplacementUtil.replaceExpression(expression2, newExpression);
    }
}

