/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.constant;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.Nullable;

class ConstantSubexpressionPredicate
implements PsiElementPredicate {
    ConstantSubexpressionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiJavaToken token;
        if (element instanceof PsiJavaToken) {
            token = (PsiJavaToken)element;
        } else {
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling instanceof PsiJavaToken) {
                token = (PsiJavaToken)prevSibling;
            } else {
                return false;
            }
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        PsiType type2 = polyadicExpression.getType();
        if (type2 == null || type2.equalsToText("java.lang.String")) {
            return false;
        }
        PsiPolyadicExpression subexpression = ConstantSubexpressionPredicate.getSubexpression(polyadicExpression, token);
        if (subexpression == null) {
            return false;
        }
        if (!ConstantSubexpressionPredicate.isPartOfLargerExpression(polyadicExpression)) {
            return false;
        }
        if (!PsiUtil.isConstantExpression((PsiExpression)subexpression)) {
            return false;
        }
        Object value2 = ExpressionUtils.computeConstantExpression((PsiExpression)subexpression);
        return value2 != null;
    }

    @Nullable
    static PsiPolyadicExpression getSubexpression(PsiPolyadicExpression expression2, PsiJavaToken token) {
        PsiExpression[] operands2 = expression2.getOperands();
        if (operands2.length == 2) {
            return expression2;
        }
        for (int i2 = 1; i2 < operands2.length; ++i2) {
            PsiExpression operand2 = operands2[i2];
            PsiJavaToken currentToken = expression2.getTokenBeforeOperand(operand2);
            if (currentToken != token) continue;
            String binaryExpressionText = operands2[i2 - 1].getText() + ' ' + token.getText() + ' ' + operand2.getText();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
            return (PsiPolyadicExpression)factory.createExpressionFromText(binaryExpressionText, (PsiElement)expression2);
        }
        return null;
    }

    private static boolean isPartOfLargerExpression(PsiPolyadicExpression expression2) {
        if (expression2.getOperands().length > 2) {
            return true;
        }
        PsiElement containingElement = expression2.getParent();
        if (containingElement instanceof PsiExpression) {
            PsiExpression containingExpression = (PsiExpression)containingElement;
            return PsiUtil.isConstantExpression((PsiExpression)containingExpression);
        }
        return false;
    }
}

