/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.equality;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.equality.EqualsPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceEqualsWithEqualityIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        EqualsPredicate equalsPredicate = new EqualsPredicate();
        if (equalsPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/equality/ReplaceEqualsWithEqualityIntention", "getElementPredicate"));
        }
        return equalsPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        if (call == null) {
            return;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        PsiExpression target2 = methodExpression.getQualifierExpression();
        if (target2 == null) {
            return;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression arg = argumentList.getExpressions()[0];
        PsiExpression strippedTarget = ParenthesesUtils.stripParentheses(target2);
        if (strippedTarget == null) {
            return;
        }
        PsiExpression strippedArg = ParenthesesUtils.stripParentheses(arg);
        if (strippedArg == null) {
            return;
        }
        String strippedArgText = ParenthesesUtils.getPrecedence(strippedArg) > 9 ? '(' + strippedArg.getText() + ')' : strippedArg.getText();
        String strippedTargetText = ParenthesesUtils.getPrecedence(strippedTarget) > 9 ? '(' + strippedTarget.getText() + ')' : strippedTarget.getText();
        PsiReplacementUtil.replaceExpression((PsiExpression)call, strippedTargetText + "==" + strippedArgText);
    }
}

