/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.Set;

class DetailExceptionsPredicate
implements PsiElementPredicate {
    DetailExceptionsPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        IElementType tokenType = ((PsiJavaToken)element).getTokenType();
        if (!JavaTokenType.TRY_KEYWORD.equals(tokenType) && !JavaTokenType.CATCH_KEYWORD.equals(tokenType)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiCatchSection) {
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiTryStatement)) {
            return false;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)parent;
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        Set<PsiClassType> exceptionsThrown = ExceptionUtils.calculateExceptionsThrown((PsiElement)tryBlock);
        ExceptionUtils.calculateExceptionsThrown((PsiElement)tryStatement.getResourceList(), exceptionsThrown);
        Set<PsiType> exceptionsCaught = ExceptionUtils.getExceptionTypesHandled(tryStatement);
        for (PsiType psiType : exceptionsThrown) {
            if (exceptionsCaught.contains(psiType)) continue;
            for (PsiType typeCaught : exceptionsCaught) {
                if (!typeCaught.isAssignableFrom(psiType)) continue;
                return true;
            }
        }
        return false;
    }
}

