/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.AutomaticResourceManagementPredicate;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ReplaceArmWithTryFinallyIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AutomaticResourceManagementPredicate automaticResourceManagementPredicate = new AutomaticResourceManagementPredicate();
        if (automaticResourceManagementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/exceptions/ReplaceArmWithTryFinallyIntention", "getElementPredicate"));
        }
        return automaticResourceManagementPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        int i2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/exceptions/ReplaceArmWithTryFinallyIntention", "processIntention"));
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiTryStatement tryStatement = (PsiTryStatement)token.getParent();
        if (tryStatement == null) {
            return;
        }
        boolean replaceAll = tryStatement.getCatchBlocks().length == 0 && tryStatement.getFinallyBlock() == null;
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList == null) {
            return;
        }
        ArrayList resources = ContainerUtil.newArrayList();
        StringBuilder newTryStatement = new StringBuilder("{");
        for (PsiResourceListElement resource : resourceList) {
            if (resource instanceof PsiResourceVariable) {
                newTryStatement.append(resource.getText()).append(";\n");
                resources.add(((PsiResourceVariable)resource).getName());
            } else {
                resources.add(resource.getText());
            }
            newTryStatement.append("try {");
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        PsiElement[] children2 = tryBlock.getChildren();
        for (i2 = 1; i2 < children2.length - 1; ++i2) {
            PsiElement child = children2[i2];
            newTryStatement.append(child.getText());
        }
        for (i2 = resources.size() - 1; i2 >= 0; --i2) {
            newTryStatement.append("} finally {\n").append((String)resources.get(i2)).append(".close();\n}");
        }
        newTryStatement.append('}');
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiCodeBlock newCodeBlock = factory.createCodeBlockFromText(newTryStatement.toString(), element);
        if (replaceAll) {
            for (PsiStatement newStatement : newCodeBlock.getStatements()) {
                tryStatement.getParent().addBefore((PsiElement)newStatement, (PsiElement)tryStatement);
            }
            tryStatement.delete();
        } else {
            resourceList.delete();
            tryBlock.replace((PsiElement)newCodeBlock);
        }
    }
}

