/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.ForLoopPredicate;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ReplaceForLoopWithWhileLoopIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ForLoopPredicate forLoopPredicate = new ForLoopPredicate();
        if (forLoopPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/forloop/ReplaceForLoopWithWhileLoopIntention", "getElementPredicate"));
        }
        return forLoopPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiCodeBlock loopBody;
        PsiBlockStatement blockStatement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/forloop/ReplaceForLoopWithWhileLoopIntention", "processIntention"));
        }
        PsiForStatement forStatement = (PsiForStatement)element.getParent();
        if (forStatement == null) {
            return;
        }
        PsiStatement initialization = forStatement.getInitialization();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiWhileStatement whileStatement = (PsiWhileStatement)factory.createStatementFromText("while(true) {}", element);
        PsiExpression forCondition = forStatement.getCondition();
        PsiExpression whileCondition = whileStatement.getCondition();
        if (forCondition != null) {
            assert (whileCondition != null);
            whileCondition.replace((PsiElement)forCondition);
        }
        if ((blockStatement = (PsiBlockStatement)whileStatement.getBody()) == null) {
            return;
        }
        PsiStatement forStatementBody = forStatement.getBody();
        if (forStatementBody instanceof PsiBlockStatement) {
            PsiBlockStatement newWhileBody = (PsiBlockStatement)blockStatement.replace((PsiElement)forStatementBody);
            loopBody = newWhileBody.getCodeBlock();
        } else {
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            if (forStatementBody != null && !(forStatementBody instanceof PsiEmptyStatement)) {
                codeBlock.add((PsiElement)forStatementBody);
            }
            loopBody = codeBlock;
        }
        PsiStatement update2 = forStatement.getUpdate();
        if (update2 != null) {
            PsiStatement[] updateStatements;
            if (update2 instanceof PsiExpressionListStatement) {
                PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)update2;
                PsiExpressionList expressionList = expressionListStatement.getExpressionList();
                PsiExpression[] expressions2 = expressionList.getExpressions();
                updateStatements = new PsiStatement[expressions2.length];
                for (int i2 = 0; i2 < expressions2.length; ++i2) {
                    updateStatements[i2] = factory.createStatementFromText(expressions2[i2].getText() + ';', element);
                }
            } else {
                PsiStatement updateStatement = factory.createStatementFromText(update2.getText() + ';', element);
                updateStatements = new PsiStatement[]{updateStatement};
            }
            Collection continueStatements = PsiTreeUtil.findChildrenOfType((PsiElement)loopBody, PsiContinueStatement.class);
            for (PsiContinueStatement continueStatement : continueStatements) {
                BlockUtils.addBefore((PsiStatement)continueStatement, updateStatements);
            }
            for (PsiStatement updateStatement : updateStatements) {
                loopBody.addBefore((PsiElement)updateStatement, loopBody.getLastChild());
            }
        }
        if (initialization == null || initialization instanceof PsiEmptyStatement) {
            forStatement.replace((PsiElement)whileStatement);
        } else {
            initialization = (PsiStatement)initialization.copy();
            PsiStatement newStatement = (PsiStatement)forStatement.replace((PsiElement)whileStatement);
            BlockUtils.addBefore(newStatement, initialization);
        }
    }
}

