/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.functional;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.ControlFlowWrapper;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.UniqueNameGenerator;
import com.siyeh.IntentionPowerPackBundle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtractToMethodReferenceIntention
extends BaseElementAtCaretIntentionAction {
    private static final Logger LOG = Logger.getInstance(ExtractToMethodReferenceIntention.class);

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/functional/ExtractToMethodReferenceIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = IntentionPowerPackBundle.message("extract.to.method.reference.intention.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/functional/ExtractToMethodReferenceIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ipp/functional/ExtractToMethodReferenceIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/functional/ExtractToMethodReferenceIntention", "isAvailable"));
        }
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class, (boolean)false);
        if (lambdaExpression != null) {
            PsiElement body2 = lambdaExpression.getBody();
            if (body2 == null) {
                return false;
            }
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (functionalInterfaceType == null || LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType) == null || !LambdaUtil.isLambdaFullyInferred((PsiLambdaExpression)lambdaExpression, (PsiType)functionalInterfaceType)) {
                return false;
            }
            if (LambdaRefactoringUtil.createLambdaParameterListWithFormalTypes(functionalInterfaceType, lambdaExpression, false) == null) {
                return false;
            }
            PsiExpression asMethodReference = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(body2, (PsiVariable[])lambdaExpression.getParameterList().getParameters(), functionalInterfaceType, null);
            if (asMethodReference != null) {
                return false;
            }
            try {
                PsiStatement[] psiStatementArray;
                if (body2 instanceof PsiCodeBlock) {
                    psiStatementArray = ((PsiCodeBlock)body2).getStatements();
                } else {
                    PsiElement[] psiElementArray = new PsiElement[1];
                    psiStatementArray = psiElementArray;
                    psiElementArray[0] = body2;
                }
                PsiStatement[] toExtract = psiStatementArray;
                ControlFlowWrapper wrapper = new ControlFlowWrapper(project2, body2, (PsiElement[])toExtract);
                wrapper.prepareExitStatements((PsiElement[])toExtract, body2);
                PsiVariable[] outputVariables = wrapper.getOutputVariables();
                List<PsiVariable> inputVariables = wrapper.getInputVariables(body2, (PsiElement[])toExtract, outputVariables);
                return inputVariables.stream().allMatch(variable -> variable instanceof PsiParameter && ((PsiParameter)variable).getDeclarationScope() == lambdaExpression);
            }
            catch (PrepareFailedException prepareFailedException) {
            }
            catch (ControlFlowWrapper.ExitStatementsNotSameException exitStatementsNotSameException) {
                // empty catch block
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ipp/functional/ExtractToMethodReferenceIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/functional/ExtractToMethodReferenceIntention", "invoke"));
        }
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class, (boolean)false);
        if (lambdaExpression != null) {
            PsiClass targetClass;
            PsiElement body2 = lambdaExpression.getBody();
            if (body2 instanceof PsiExpression) {
                lambdaExpression = (PsiLambdaExpression)RefactoringUtil.expandExpressionLambdaToCodeBlock(body2);
                body2 = lambdaExpression.getBody();
            }
            if ((targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PsiClass.class)) == null) {
                return;
            }
            LOG.assertTrue(body2 instanceof PsiCodeBlock);
            PsiStatement[] elements = ((PsiCodeBlock)body2).getStatements();
            HashSet<PsiField> usedFields = new HashSet<PsiField>();
            boolean canBeStatic = ExtractMethodProcessor.canBeStatic(targetClass, (PsiElement)lambdaExpression, (PsiElement[])elements, usedFields) && usedFields.isEmpty();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)targetClass.getProject());
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            String parameters2 = LambdaRefactoringUtil.createLambdaParameterListWithFormalTypes(functionalInterfaceType, lambdaExpression, false) + "{}";
            String targetMethodName = ExtractToMethodReferenceIntention.getUniqueMethodName(targetClass, elementFactory, functionalInterfaceType, parameters2);
            PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression);
            LOG.assertTrue(returnType != null);
            PsiMethod container = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PsiMethod.class);
            PsiTypeParameterList typeParamsList = container != null ? RefactoringUtil.createTypeParameterListWithUsedTypeParameters(container.getTypeParameterList(), (PsiElement[])elements) : null;
            PsiMethod emptyMethod = elementFactory.createMethodFromText("private " + (canBeStatic ? "static " : "") + (typeParamsList != null ? typeParamsList.getText() + " " : "") + returnType.getCanonicalText() + " " + targetMethodName + parameters2, (PsiElement)targetClass);
            PsiCodeBlock targetMethodBody = emptyMethod.getBody();
            LOG.assertTrue(targetMethodBody != null);
            if (elements.length > 0) {
                targetMethodBody.addRange((PsiElement)elements[0], (PsiElement)elements[elements.length - 1]);
            }
            PsiMethod method = (PsiMethod)CodeStyleManager.getInstance((Project)project2).reformat(JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(targetClass.add((PsiElement)emptyMethod)));
            PsiMethodReferenceExpression methodReference = (PsiMethodReferenceExpression)elementFactory.createExpressionFromText((canBeStatic ? targetClass.getName() : "this") + "::" + targetMethodName, (PsiElement)lambdaExpression);
            methodReference = (PsiMethodReferenceExpression)lambdaExpression.replace((PsiElement)methodReference);
            ExtractToMethodReferenceIntention.startInplaceRename(editor, method, methodReference);
        }
    }

    private static void startInplaceRename(final Editor editor, final PsiMethod method, PsiMethodReferenceExpression methodReference) {
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        nameIdentifier = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(nameIdentifier);
        editor.getCaretModel().moveToOffset(((PsiElement)ObjectUtils.notNull((Object)methodReference.getReferenceNameElement(), (Object)nameIdentifier)).getTextOffset());
        RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement((PsiElement)method);
        if (!processor2.isInplaceRenameSupported()) {
            return;
        }
        final ArrayList<String> suggestedNames = new ArrayList<String>();
        suggestedNames.add(method.getName());
        processor2.substituteElementToRename((PsiElement)method, editor, new Pass<PsiElement>(){

            public void pass(PsiElement substitutedElement) {
                MemberInplaceRenamer renamer = new MemberInplaceRenamer((PsiNamedElement)method, substitutedElement, editor);
                LinkedHashSet<String> nameSuggestions = new LinkedHashSet<String>(suggestedNames);
                renamer.performInplaceRefactoring(nameSuggestions);
            }
        });
    }

    private static String getUniqueMethodName(PsiClass targetClass, PsiElementFactory elementFactory, PsiType functionalInterfaceType, String parameters2) {
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        String initialMethodName = interfaceMethod != null ? interfaceMethod.getName() : "name";
        return UniqueNameGenerator.generateUniqueName((String)initialMethodName, methodName -> {
            String methodText = "private void " + methodName + parameters2;
            PsiMethod patternMethod = elementFactory.createMethodFromText(methodText, (PsiElement)targetClass);
            return targetClass.findMethodBySignature(patternMethod, true) == null;
        });
    }
}

