/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ipp.base.PsiElementPredicate;

class ConvertIntegerToDecimalPredicate
implements PsiElementPredicate {
    ConvertIntegerToDecimalPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression expression2 = (PsiLiteralExpression)element;
        PsiType type2 = expression2.getType();
        if (PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2)) {
            String text2 = expression2.getText();
            if (text2 == null || text2.length() < 2) {
                return false;
            }
            if ("0".equals(text2) || "0L".equals(text2) || "0l".equals(text2)) {
                return false;
            }
            return text2.charAt(0) == '0';
        }
        if (PsiType.DOUBLE.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2)) {
            String text3 = expression2.getText();
            if (text3 == null || text3.length() < 2) {
                return false;
            }
            return text3.startsWith("0x") || text3.startsWith("0X");
        }
        return false;
    }
}

