/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.fileTypes.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashSet;
import icons.ImagesIcons;
import java.util.Collection;
import javax.imageio.ImageIO;
import org.intellij.images.ImagesBundle;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class ImageFileTypeManagerImpl
extends ImageFileTypeManager {
    @NonNls
    private static final String IMAGE_FILE_TYPE_NAME = "Images";
    private static final String IMAGE_FILE_TYPE_DESCRIPTION = ImagesBundle.message("images.filetype.description", new Object[0]);
    private static final UserFileType imageFileType = new ImageFileType();

    ImageFileTypeManagerImpl() {
    }

    @Override
    public boolean isImage(VirtualFile file2) {
        return file2.getFileType() instanceof ImageFileType;
    }

    @Override
    public FileType getImageFileType() {
        return imageFileType;
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        String[] readerFormatNames;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/intellij/images/fileTypes/impl/ImageFileTypeManagerImpl", "createFileTypes"));
        }
        THashSet processed2 = new THashSet();
        for (String format : readerFormatNames = ImageIO.getReaderFormatNames()) {
            String ext = format.toLowerCase();
            processed2.add(ext);
        }
        processed2.add("ico".toLowerCase());
        if (Registry.is((String)"ide.svg.viewer")) {
            processed2.add("svg".toLowerCase());
        }
        consumer.consume((FileType)imageFileType, StringUtil.join((Collection)processed2, (String)";"));
    }

    static {
        imageFileType.setIcon(ImagesIcons.ImagesFileType);
        imageFileType.setName(IMAGE_FILE_TYPE_NAME);
        imageFileType.setDescription(IMAGE_FILE_TYPE_DESCRIPTION);
    }

    public static final class ImageFileType
    extends UserBinaryFileType {
    }
}

