/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import javax.swing.JComponent;
import org.intellij.images.search.ImageTagManager;
import org.intellij.images.search.TagFilter;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actionSystem.ThumbnailViewActionUtil;
import org.intellij.images.thumbnail.actions.FilterImagesAction;
import org.jetbrains.annotations.NotNull;

public final class FilterByTagComboBoxAction
extends ComboBoxAction {
    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
        ImageTagManager tagManager = ImageTagManager.getInstance(project2);
        e.getPresentation().setVisible(view != null && !tagManager.getAllTags().isEmpty());
        TagFilter filter = view != null ? view.getTagFilter() : null;
        e.getPresentation().setText(filter == null ? "All" : filter.getDisplayName());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)button));
        ImageTagManager tagManager = ImageTagManager.getInstance(project2);
        group.add((AnAction)new FilterImagesAction(new TagFilter("All", tagManager){

            @Override
            public String getDisplayName() {
                return "All";
            }

            @Override
            public boolean accepts(VirtualFile file2) {
                return true;
            }

            @Override
            public boolean isApplicableToProject(Project project2) {
                return true;
            }
        }));
        for (String tag : tagManager.getAllTags()) {
            group.add((AnAction)new FilterImagesAction(new TagFilter(tag, tagManager)));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/actions/FilterByTagComboBoxAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }
}

