/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import org.intellij.lang.regexp.AsciiUtil;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RegExpLanguageHost {
    public static final EnumSet<RegExpGroup.Type> EMPTY_NAMED_GROUP_TYPES = EnumSet.noneOf(RegExpGroup.Type.class);

    public boolean characterNeedsEscaping(char var1);

    public boolean supportsPerl5EmbeddedComments();

    public boolean supportsPossessiveQuantifiers();

    public boolean supportsPythonConditionalRefs();

    public boolean supportsNamedGroupSyntax(RegExpGroup var1);

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef var1);

    @NotNull
    default public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        EnumSet<RegExpGroup.Type> enumSet = EMPTY_NAMED_GROUP_TYPES;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpLanguageHost", "getSupportedNamedGroupTypes"));
        }
        return enumSet;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar var1);

    default public boolean isValidGroupName(String name2, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/lang/regexp/RegExpLanguageHost", "isValidGroupName"));
        }
        int length = name2.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c = name2.charAt(i2);
            if (AsciiUtil.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    default public boolean supportsSimpleClass(RegExpSimpleClass simpleClass) {
        return true;
    }

    default public boolean supportsNamedCharacters(RegExpNamedCharacter namedCharacter) {
        return false;
    }

    default public boolean isValidNamedCharacter(RegExpNamedCharacter namedCharacter) {
        return this.supportsNamedCharacters(namedCharacter);
    }

    default public boolean supportsBoundary(RegExpBoundary boundary) {
        switch (boundary.getType()) {
            case UNICODE_EXTENDED_GRAPHEME: {
                return false;
            }
        }
        return true;
    }

    default public boolean supportsLiteralBackspace(RegExpChar aChar) {
        return true;
    }

    default public boolean supportsInlineOptionFlag(char flag, PsiElement context) {
        return true;
    }

    public boolean isValidCategory(@NotNull String var1);

    @NotNull
    public String[][] getAllKnownProperties();

    @Nullable
    public String getPropertyDescription(@Nullable String var1);

    @NotNull
    public String[][] getKnownCharacterClasses();

    @Nullable
    default public Number getQuantifierValue(@NotNull RegExpNumber number) {
        if (number == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "number", "org/intellij/lang/regexp/RegExpLanguageHost", "getQuantifierValue"));
        }
        return Double.parseDouble(number.getText());
    }

    default public Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        if (lookbehindGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookbehindGroup", "org/intellij/lang/regexp/RegExpLanguageHost", "supportsLookbehind"));
        }
        return Lookbehind.FULL;
    }

    public static enum Lookbehind {
        NOT_SUPPORTED,
        FIXED_LENGTH_ALTERNATION,
        VARIABLE_LENGTH_ALTERNATION,
        FINITE_REPETITION,
        FULL;

    }
}

