/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpPyCondRef;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegExpLanguageHosts
extends ClassExtension<RegExpLanguageHost> {
    private static final RegExpLanguageHosts INSTANCE = new RegExpLanguageHosts();
    private final DefaultRegExpPropertiesProvider myDefaultProvider = DefaultRegExpPropertiesProvider.getInstance();

    public static RegExpLanguageHosts getInstance() {
        return INSTANCE;
    }

    private RegExpLanguageHosts() {
        super("com.intellij.regExpLanguageHost");
    }

    @Contract(value="null -> null")
    @Nullable
    private static RegExpLanguageHost findRegExpHost(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file2 = element.getContainingFile();
        PsiElement context = file2.getContext();
        if (context instanceof RegExpLanguageHost) {
            return (RegExpLanguageHost)context;
        }
        if (context != null) {
            return (RegExpLanguageHost)INSTANCE.forClass(context.getClass());
        }
        return null;
    }

    public boolean isRedundantEscape(@NotNull RegExpChar ch, @NotNull String text2) {
        if (ch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ch", "org/intellij/lang/regexp/RegExpLanguageHosts", "isRedundantEscape"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/lang/regexp/RegExpLanguageHosts", "isRedundantEscape"));
        }
        if (text2.length() <= 1) {
            return false;
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(ch);
        if (host != null) {
            char c = text2.charAt(1);
            return !host.characterNeedsEscaping(c);
        }
        return !"\\]".equals(text2) && !"\\}".equals(text2);
    }

    public boolean supportsInlineOptionFlag(char flag, PsiElement context) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(context);
        return host == null || host.supportsInlineOptionFlag(flag, context);
    }

    public boolean supportsExtendedHexCharacter(@Nullable RegExpChar regExpChar) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(regExpChar);
        try {
            return host != null && host.supportsExtendedHexCharacter(regExpChar);
        }
        catch (AbstractMethodError e) {
            return false;
        }
    }

    public boolean supportsLiteralBackspace(@Nullable RegExpChar regExpChar) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(regExpChar);
        return host != null && host.supportsLiteralBackspace(regExpChar);
    }

    public boolean supportsNamedGroupSyntax(@Nullable RegExpGroup group) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(group);
        return host != null && host.supportsNamedGroupSyntax(group);
    }

    public boolean supportsNamedGroupRefSyntax(@Nullable RegExpNamedGroupRef ref) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(ref);
        try {
            return host != null && host.supportsNamedGroupRefSyntax(ref);
        }
        catch (AbstractMethodError e) {
            return false;
        }
    }

    public Collection<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(context);
        if (host == null) {
            return Collections.emptySet();
        }
        return host.getSupportedNamedGroupTypes(context);
    }

    public boolean isValidGroupName(String name2, @Nullable PsiElement context) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(context);
        return host != null && host.isValidGroupName(name2, context);
    }

    public boolean supportsPerl5EmbeddedComments(@Nullable PsiComment comment) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost((PsiElement)comment);
        return host != null && host.supportsPerl5EmbeddedComments();
    }

    public boolean supportsPythonConditionalRefs(@Nullable RegExpPyCondRef condRef) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(condRef);
        return host != null && host.supportsPythonConditionalRefs();
    }

    public boolean supportsPossessiveQuantifiers(@Nullable RegExpElement context) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(context);
        return host == null || host.supportsPossessiveQuantifiers();
    }

    public boolean supportsBoundary(@Nullable RegExpBoundary boundary) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(boundary);
        return host == null || host.supportsBoundary(boundary);
    }

    public boolean supportsSimpleClass(@Nullable RegExpSimpleClass simpleClass) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(simpleClass);
        return host == null || host.supportsSimpleClass(simpleClass);
    }

    public boolean isValidCategory(@NotNull PsiElement element, @NotNull String category) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/regexp/RegExpLanguageHosts", "isValidCategory"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "org/intellij/lang/regexp/RegExpLanguageHosts", "isValidCategory"));
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(element);
        return host != null ? host.isValidCategory(category) : this.myDefaultProvider.isValidCategory(category);
    }

    public boolean supportsNamedCharacters(@NotNull RegExpNamedCharacter namedCharacter) {
        if (namedCharacter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedCharacter", "org/intellij/lang/regexp/RegExpLanguageHosts", "supportsNamedCharacters"));
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(namedCharacter);
        return host != null && host.supportsNamedCharacters(namedCharacter);
    }

    public boolean isValidNamedCharacter(@NotNull RegExpNamedCharacter namedCharacter) {
        if (namedCharacter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedCharacter", "org/intellij/lang/regexp/RegExpLanguageHosts", "isValidNamedCharacter"));
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(namedCharacter);
        return host != null && host.isValidNamedCharacter(namedCharacter);
    }

    public RegExpLanguageHost.Lookbehind supportsLookbehind(RegExpGroup group) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(group);
        if (host == null) {
            return RegExpLanguageHost.Lookbehind.FULL;
        }
        return host.supportsLookbehind(group);
    }

    @Nullable
    public Number getQuantifierValue(@NotNull RegExpNumber valueElement) {
        if (valueElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueElement", "org/intellij/lang/regexp/RegExpLanguageHosts", "getQuantifierValue"));
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(valueElement);
        if (host == null) {
            return Double.valueOf(valueElement.getText());
        }
        return host.getQuantifierValue(valueElement);
    }

    @NotNull
    public String[][] getAllKnownProperties(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/regexp/RegExpLanguageHosts", "getAllKnownProperties"));
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(element);
        String[][] stringArray = host != null ? host.getAllKnownProperties() : this.myDefaultProvider.getAllKnownProperties();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpLanguageHosts", "getAllKnownProperties"));
        }
        return stringArray;
    }

    @Nullable
    String getPropertyDescription(@NotNull PsiElement element, @Nullable String name2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/regexp/RegExpLanguageHosts", "getPropertyDescription"));
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(element);
        return host != null ? host.getPropertyDescription(name2) : this.myDefaultProvider.getPropertyDescription(name2);
    }

    @NotNull
    String[][] getKnownCharacterClasses(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/regexp/RegExpLanguageHosts", "getKnownCharacterClasses"));
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(element);
        String[][] stringArray = host != null ? host.getKnownCharacterClasses() : this.myDefaultProvider.getKnownCharacterClasses();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpLanguageHosts", "getKnownCharacterClasses"));
        }
        return stringArray;
    }

    String[][] getPosixCharacterClasses(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/regexp/RegExpLanguageHosts", "getPosixCharacterClasses"));
        }
        return this.myDefaultProvider.getPosixCharacterClasses();
    }
}

