/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.EnumSet;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpParser;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.impl.RegExpBackrefImpl;
import org.intellij.lang.regexp.psi.impl.RegExpBoundaryImpl;
import org.intellij.lang.regexp.psi.impl.RegExpBranchImpl;
import org.intellij.lang.regexp.psi.impl.RegExpCharImpl;
import org.intellij.lang.regexp.psi.impl.RegExpCharRangeImpl;
import org.intellij.lang.regexp.psi.impl.RegExpClassImpl;
import org.intellij.lang.regexp.psi.impl.RegExpClosureImpl;
import org.intellij.lang.regexp.psi.impl.RegExpGroupImpl;
import org.intellij.lang.regexp.psi.impl.RegExpIntersectionImpl;
import org.intellij.lang.regexp.psi.impl.RegExpNamedCharacterImpl;
import org.intellij.lang.regexp.psi.impl.RegExpNamedGroupRefImpl;
import org.intellij.lang.regexp.psi.impl.RegExpNumberImpl;
import org.intellij.lang.regexp.psi.impl.RegExpOptionsImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPatternImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPosixBracketExpressionImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPropertyImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPyCondRefImpl;
import org.intellij.lang.regexp.psi.impl.RegExpQuantifierImpl;
import org.intellij.lang.regexp.psi.impl.RegExpSetOptionsImpl;
import org.intellij.lang.regexp.psi.impl.RegExpSimpleClassImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpParserDefinition
implements ParserDefinition {
    private static final TokenSet WHITE_SPACE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.QUOTE_BEGIN, RegExpTT.QUOTE_END, TokenType.WHITE_SPACE});
    private static final TokenSet COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.COMMENT});
    private static final EnumSet<RegExpCapability> CAPABILITIES = EnumSet.of(RegExpCapability.NESTED_CHARACTER_CLASSES, RegExpCapability.ALLOW_HORIZONTAL_WHITESPACE_CLASS, RegExpCapability.UNICODE_CATEGORY_SHORTHAND, RegExpCapability.EXTENDED_UNICODE_CHARACTER);

    @NotNull
    public Lexer createLexer(Project project2) {
        RegExpLexer regExpLexer = new RegExpLexer(CAPABILITIES);
        if (regExpLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createLexer"));
        }
        return regExpLexer;
    }

    public PsiParser createParser(Project project2) {
        return new RegExpParser(CAPABILITIES);
    }

    public IFileElementType getFileNodeType() {
        return RegExpElementTypes.REGEXP_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITE_SPACE_TOKENS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = COMMENT_TOKENS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type2 = node.getElementType();
        if (type2 == RegExpElementTypes.PATTERN) {
            RegExpPatternImpl regExpPatternImpl = new RegExpPatternImpl(node);
            if (regExpPatternImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpPatternImpl;
        }
        if (type2 == RegExpElementTypes.BRANCH) {
            RegExpBranchImpl regExpBranchImpl = new RegExpBranchImpl(node);
            if (regExpBranchImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpBranchImpl;
        }
        if (type2 == RegExpElementTypes.SIMPLE_CLASS) {
            RegExpSimpleClassImpl regExpSimpleClassImpl = new RegExpSimpleClassImpl(node);
            if (regExpSimpleClassImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpSimpleClassImpl;
        }
        if (type2 == RegExpElementTypes.CLASS) {
            RegExpClassImpl regExpClassImpl = new RegExpClassImpl(node);
            if (regExpClassImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpClassImpl;
        }
        if (type2 == RegExpElementTypes.CHAR_RANGE) {
            RegExpCharRangeImpl regExpCharRangeImpl = new RegExpCharRangeImpl(node);
            if (regExpCharRangeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpCharRangeImpl;
        }
        if (type2 == RegExpElementTypes.CHAR) {
            RegExpCharImpl regExpCharImpl = new RegExpCharImpl(node);
            if (regExpCharImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpCharImpl;
        }
        if (type2 == RegExpElementTypes.GROUP) {
            RegExpGroupImpl regExpGroupImpl = new RegExpGroupImpl(node);
            if (regExpGroupImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpGroupImpl;
        }
        if (type2 == RegExpElementTypes.PROPERTY) {
            RegExpPropertyImpl regExpPropertyImpl = new RegExpPropertyImpl(node);
            if (regExpPropertyImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpPropertyImpl;
        }
        if (type2 == RegExpElementTypes.NAMED_CHARACTER) {
            RegExpNamedCharacterImpl regExpNamedCharacterImpl = new RegExpNamedCharacterImpl(node);
            if (regExpNamedCharacterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpNamedCharacterImpl;
        }
        if (type2 == RegExpElementTypes.SET_OPTIONS) {
            RegExpSetOptionsImpl regExpSetOptionsImpl = new RegExpSetOptionsImpl(node);
            if (regExpSetOptionsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpSetOptionsImpl;
        }
        if (type2 == RegExpElementTypes.OPTIONS) {
            RegExpOptionsImpl regExpOptionsImpl = new RegExpOptionsImpl(node);
            if (regExpOptionsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpOptionsImpl;
        }
        if (type2 == RegExpElementTypes.BACKREF) {
            RegExpBackrefImpl regExpBackrefImpl = new RegExpBackrefImpl(node);
            if (regExpBackrefImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpBackrefImpl;
        }
        if (type2 == RegExpElementTypes.CLOSURE) {
            RegExpClosureImpl regExpClosureImpl = new RegExpClosureImpl(node);
            if (regExpClosureImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpClosureImpl;
        }
        if (type2 == RegExpElementTypes.QUANTIFIER) {
            RegExpQuantifierImpl regExpQuantifierImpl = new RegExpQuantifierImpl(node);
            if (regExpQuantifierImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpQuantifierImpl;
        }
        if (type2 == RegExpElementTypes.BOUNDARY) {
            RegExpBoundaryImpl regExpBoundaryImpl = new RegExpBoundaryImpl(node);
            if (regExpBoundaryImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpBoundaryImpl;
        }
        if (type2 == RegExpElementTypes.INTERSECTION) {
            RegExpIntersectionImpl regExpIntersectionImpl = new RegExpIntersectionImpl(node);
            if (regExpIntersectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpIntersectionImpl;
        }
        if (type2 == RegExpElementTypes.NAMED_GROUP_REF) {
            RegExpNamedGroupRefImpl regExpNamedGroupRefImpl = new RegExpNamedGroupRefImpl(node);
            if (regExpNamedGroupRefImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpNamedGroupRefImpl;
        }
        if (type2 == RegExpElementTypes.PY_COND_REF) {
            RegExpPyCondRefImpl regExpPyCondRefImpl = new RegExpPyCondRefImpl(node);
            if (regExpPyCondRefImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpPyCondRefImpl;
        }
        if (type2 == RegExpElementTypes.POSIX_BRACKET_EXPRESSION) {
            RegExpPosixBracketExpressionImpl regExpPosixBracketExpressionImpl = new RegExpPosixBracketExpressionImpl(node);
            if (regExpPosixBracketExpressionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpPosixBracketExpressionImpl;
        }
        if (type2 == RegExpElementTypes.NUMBER) {
            RegExpNumberImpl regExpNumberImpl = new RegExpNumberImpl(node);
            if (regExpNumberImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpNumberImpl;
        }
        ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
        if (aSTWrapperPsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
        }
        return aSTWrapperPsiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new RegExpFile(viewProvider, RegExpLanguage.INSTANCE);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MUST_NOT;
    }
}

