/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EmptyAlternationBranchInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Empty branch in alternation" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection", "getDisplayName"));
        }
        return "Empty branch in alternation";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection", "buildVisitor"));
        }
        EmptyAlternationBranchVisitor emptyAlternationBranchVisitor = new EmptyAlternationBranchVisitor(holder);
        if (emptyAlternationBranchVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection", "buildVisitor"));
        }
        return emptyAlternationBranchVisitor;
    }

    private static class DuplicateAlternationBranchFix
    implements LocalQuickFix {
        private final boolean myDeleteNext;

        public DuplicateAlternationBranchFix(boolean deleteNext) {
            this.myDeleteNext = deleteNext;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Remove empty branch" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection$DuplicateAlternationBranchFix", "getFamilyName"));
            }
            return "Remove empty branch";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection$DuplicateAlternationBranchFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection$DuplicateAlternationBranchFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (this.myDeleteNext) {
                element.getNextSibling().delete();
            } else {
                element.getPrevSibling().delete();
            }
            element.delete();
        }
    }

    private static class EmptyAlternationBranchVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        public EmptyAlternationBranchVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            RegExpBranch[] branches = pattern.getBranches();
            if (branches.length < 2) {
                return;
            }
            boolean nonEmptyBranchSeen = false;
            for (RegExpBranch branch : branches) {
                PsiElement element;
                if (branch.getAtoms().length != 0) {
                    nonEmptyBranchSeen = true;
                    continue;
                }
                DuplicateAlternationBranchFix fix = new DuplicateAlternationBranchFix(nonEmptyBranchSeen);
                PsiElement psiElement = element = nonEmptyBranchSeen ? branch.getPrevSibling() : branch.getNextSibling();
                if (element == null) continue;
                this.myHolder.registerProblem(element, "Empty branch in alternation", new LocalQuickFix[]{fix});
            }
        }
    }
}

