/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.inspection.RegExpFactory;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EscapedMetaCharacterInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Escaped meta character" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/EscapedMetaCharacterInspection", "getDisplayName"));
        }
        return "Escaped meta character";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/EscapedMetaCharacterInspection", "buildVisitor"));
        }
        EscapedMetaCharacterVisitor escapedMetaCharacterVisitor = new EscapedMetaCharacterVisitor(holder);
        if (escapedMetaCharacterVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/EscapedMetaCharacterInspection", "buildVisitor"));
        }
        return escapedMetaCharacterVisitor;
    }

    private static class EscapedMetaCharacterFix
    implements LocalQuickFix {
        private final char myC;

        EscapedMetaCharacterFix(char c) {
            this.myC = c;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with '[" + this.myC + "]'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/EscapedMetaCharacterInspection$EscapedMetaCharacterFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with character inside class" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/EscapedMetaCharacterInspection$EscapedMetaCharacterFix", "getFamilyName"));
            }
            return "Replace with character inside class";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/regexp/inspection/EscapedMetaCharacterInspection$EscapedMetaCharacterFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/intellij/lang/regexp/inspection/EscapedMetaCharacterInspection$EscapedMetaCharacterFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof RegExpChar)) {
                return;
            }
            RegExpBranch branch = RegExpFactory.createBranchFromText("[" + this.myC + ']', element);
            element.replace(branch.getFirstChild());
        }
    }

    private static class EscapedMetaCharacterVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        public EscapedMetaCharacterVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            if (ch.getType() != RegExpChar.Type.CHAR) {
                return;
            }
            String text2 = ch.getUnescapedText();
            if (text2.length() != 2 || text2.charAt(0) != '\\') {
                return;
            }
            char c = text2.charAt(1);
            if ("{}().*+?|$".indexOf(c) < 0) {
                return;
            }
            ASTNode node = ch.getNode().getFirstChildNode();
            if (node != null && node.getElementType() == RegExpTT.REDUNDANT_ESCAPE) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)ch, "Escaped meta character <code>" + c + "</code>", new LocalQuickFix[]{new EscapedMetaCharacterFix(c)});
        }
    }
}

