/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.NotNull;

public class RegExpFactory {
    private RegExpFactory() {
    }

    @NotNull
    public static RegExpPattern createPatternFromText(@NotNull CharSequence text2, @NotNull PsiElement context) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/lang/regexp/inspection/RegExpFactory", "createPatternFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/lang/regexp/inspection/RegExpFactory", "createPatternFromText"));
        }
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)context.getProject());
        PsiFile file2 = factory.createFileFromText("dummy.regexp", (FileType)RegExpFileType.INSTANCE, text2);
        RegExpPattern pattern = (RegExpPattern)PsiTreeUtil.getChildOfType((PsiElement)file2, RegExpPattern.class);
        assert (pattern != null);
        RegExpPattern regExpPattern = pattern;
        if (regExpPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/RegExpFactory", "createPatternFromText"));
        }
        return regExpPattern;
    }

    @NotNull
    public static RegExpBranch createBranchFromText(@NotNull CharSequence text2, @NotNull PsiElement context) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/lang/regexp/inspection/RegExpFactory", "createBranchFromText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/lang/regexp/inspection/RegExpFactory", "createBranchFromText"));
        }
        RegExpPattern pattern = RegExpFactory.createPatternFromText(text2, context);
        RegExpBranch branch = (RegExpBranch)PsiTreeUtil.getChildOfType((PsiElement)pattern, RegExpBranch.class);
        assert (branch != null);
        RegExpBranch regExpBranch = branch;
        if (regExpBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/inspection/RegExpFactory", "createBranchFromText"));
        }
        return regExpBranch;
    }
}

