/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Consumer;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextBase;
import org.jetbrains.debugger.SuspendContextManager;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0013\u0010\u001f\u001a\u00020 2\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020 H\u0004J\u0018\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030$H\u0004J\f\u0010&\u001a\u0006\u0012\u0002\b\u00030$H$J\u001b\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170$2\u0006\u0010\u001e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010(J#\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170$2\u0006\u0010\u001e\u001a\u00028\u00012\u0006\u0010)\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010*J\u0013\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J\u0012\u0010-\u001a\u00020 2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0018\u00100\u001a\u0012\u0012\u000e\b\u0001\u0012\n 2*\u0004\u0018\u000101010$H\u0016J\u0014\u00103\u001a\u00020 2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\bH\u0016R\u001c\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0018R \u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011\u00a8\u00064"}, d2={"Lorg/jetbrains/debugger/SuspendContextManagerBase;", "T", "Lorg/jetbrains/debugger/SuspendContextBase;", "CALL_FRAME", "Lorg/jetbrains/debugger/CallFrame;", "Lorg/jetbrains/debugger/SuspendContextManager;", "()V", "context", "Lorg/jetbrains/debugger/SuspendContext;", "getContext", "()Lorg/jetbrains/debugger/SuspendContext;", "contextOrFail", "getContextOrFail", "()Lorg/jetbrains/debugger/SuspendContextBase;", "contextRef", "Ljava/util/concurrent/atomic/AtomicReference;", "getContextRef", "()Ljava/util/concurrent/atomic/AtomicReference;", "debugListener", "Lorg/jetbrains/debugger/DebugEventListener;", "getDebugListener", "()Lorg/jetbrains/debugger/DebugEventListener;", "isRestartFrameSupported", "", "()Z", "suspendCallback", "Lorg/jetbrains/concurrency/AsyncPromise;", "Ljava/lang/Void;", "getSuspendCallback", "canRestartFrame", "callFrame", "contextDismissed", "", "(Lorg/jetbrains/debugger/SuspendContextBase;)V", "dismissContext", "dismissContextOnDone", "Lorg/jetbrains/concurrency/Promise;", "promise", "doSuspend", "restartFrame", "(Lorg/jetbrains/debugger/CallFrame;)Lorg/jetbrains/concurrency/Promise;", "currentContext", "(Lorg/jetbrains/debugger/CallFrame;Lorg/jetbrains/debugger/SuspendContextBase;)Lorg/jetbrains/concurrency/Promise;", "setContext", "newContext", "setOverlayMessage", "message", "", "suspend", "", "kotlin.jvm.PlatformType", "updateContext", "script-debugger-backend"})
public abstract class SuspendContextManagerBase<T extends SuspendContextBase<CALL_FRAME>, CALL_FRAME extends CallFrame>
implements SuspendContextManager<CALL_FRAME> {
    @NotNull
    private final AtomicReference<T> contextRef = new AtomicReference();
    @NotNull
    private final AtomicReference<AsyncPromise<Void>> suspendCallback = new AtomicReference();
    private final boolean isRestartFrameSupported = false;

    @NotNull
    public final AtomicReference<T> getContextRef() {
        return this.contextRef;
    }

    @NotNull
    protected final AtomicReference<AsyncPromise<Void>> getSuspendCallback() {
        return this.suspendCallback;
    }

    @NotNull
    protected abstract DebugEventListener getDebugListener();

    public final void setContext(@NotNull T newContext) {
        Intrinsics.checkParameterIsNotNull(newContext, (String)"newContext");
        if (!this.contextRef.compareAndSet(null, newContext)) {
            throw (Throwable)new IllegalStateException("Attempt to set context, but current suspend context is already exists");
        }
    }

    public void updateContext(@NotNull SuspendContext<?> newContext) {
        Intrinsics.checkParameterIsNotNull(newContext, (String)"newContext");
    }

    protected final void dismissContext() {
        block0: {
            SuspendContextBase suspendContextBase;
            SuspendContextBase suspendContextBase2 = (SuspendContextBase)this.contextRef.get();
            if (suspendContextBase2 == null) break block0;
            SuspendContextBase it = suspendContextBase = suspendContextBase2;
            this.contextDismissed(it);
        }
    }

    @NotNull
    protected final Promise<?> dismissContextOnDone(@NotNull Promise<?> promise2) {
        Intrinsics.checkParameterIsNotNull(promise2, (String)"promise");
        SuspendContext context = this.getContextOrFail();
        promise2.done((Consumer)new Consumer<Object>(this, (SuspendContextBase)context){
            final /* synthetic */ SuspendContextManagerBase this$0;
            final /* synthetic */ SuspendContextBase $context;

            public final void consume(Object it) {
                this.this$0.contextDismissed(this.$context);
            }
            {
                this.this$0 = suspendContextManagerBase;
                this.$context = suspendContextBase;
            }
        });
        return promise2;
    }

    public final void contextDismissed(@NotNull T context) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (!this.contextRef.compareAndSet(context, null)) {
            throw (Throwable)new IllegalStateException("Expected " + context + ", but another suspend context exists");
        }
        context.getValueManager().markObsolete();
        this.getDebugListener().resumed(((SuspendContextBase)context).getVm());
    }

    @Override
    @Nullable
    public SuspendContext<CALL_FRAME> getContext() {
        return (SuspendContext)this.contextRef.get();
    }

    @NotNull
    public T getContextOrFail() {
        SuspendContextBase suspendContextBase = (SuspendContextBase)this.contextRef.get();
        if (suspendContextBase == null) {
            throw (Throwable)new IllegalStateException("No current suspend context");
        }
        return (T)suspendContextBase;
    }

    @Override
    @NotNull
    public Promise<? extends Object> suspend() {
        AsyncPromise<Void> asyncPromise = this.suspendCallback.get();
        return asyncPromise != null ? (Promise<?>)asyncPromise : (this.getContext() == null ? this.doSuspend() : Promises.resolvedPromise());
    }

    @NotNull
    protected abstract Promise<?> doSuspend();

    @Override
    public void setOverlayMessage(@Nullable String message2) {
    }

    @Override
    @NotNull
    public Promise<Boolean> restartFrame(@NotNull CALL_FRAME callFrame) {
        Intrinsics.checkParameterIsNotNull(callFrame, (String)"callFrame");
        return this.restartFrame(callFrame, this.getContextOrFail());
    }

    @NotNull
    protected Promise<Boolean> restartFrame(@NotNull CALL_FRAME callFrame, @NotNull T currentContext) {
        Intrinsics.checkParameterIsNotNull(callFrame, (String)"callFrame");
        Intrinsics.checkParameterIsNotNull(currentContext, (String)"currentContext");
        return Promises.rejectedPromise((String)"Unsupported");
    }

    @Override
    public boolean canRestartFrame(@NotNull CallFrame callFrame) {
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        return false;
    }

    @Override
    public boolean isRestartFrameSupported() {
        return this.isRestartFrameSupported;
    }

    @Override
    public boolean isContextObsolete(@NotNull SuspendContext<?> context) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        return SuspendContextManager.DefaultImpls.isContextObsolete(this, context);
    }
}

