/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.Value;

public class VariableImpl
implements Variable {
    protected volatile Value value;
    private final String name;
    private final ValueModifier valueModifier;

    public VariableImpl(@NotNull String name2, @Nullable Value value2, @Nullable ValueModifier valueModifier) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/VariableImpl", "<init>"));
        }
        this.name = name2;
        this.value = value2;
        this.valueModifier = valueModifier;
    }

    public VariableImpl(@NotNull String name2, @NotNull Value value2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/VariableImpl", "<init>"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/VariableImpl", "<init>"));
        }
        this(name2, value2, null);
    }

    @Override
    @Nullable
    public final ValueModifier getValueModifier() {
        return this.valueModifier;
    }

    @Override
    @NotNull
    public final String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableImpl", "getName"));
        }
        return string;
    }

    @Override
    @Nullable
    public final Value getValue() {
        return this.value;
    }

    @Override
    public void setValue(Value value2) {
        this.value = value2;
    }

    @Override
    public boolean isMutable() {
        return this.valueModifier != null;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    public String toString() {
        return "[Variable: name=" + this.getName() + ", value=" + this.getValue() + ']';
    }
}

