/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonToken;
import java.io.Closeable;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonReaderEx
implements Closeable {
    private static final char[] NON_EXECUTE_PREFIX = ")]}'\n".toCharArray();
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_EOF = 17;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    private final CharSequence in;
    private boolean lenient;
    private int position;
    private final int limit;
    private int peeked;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int[] stack;
    private int stackSize;
    private StringBuilder builder;

    public JsonReaderEx(@NotNull CharSequence in) {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/io/JsonReaderEx", "<init>"));
        }
        this(in, 0);
    }

    public JsonReaderEx(@NotNull CharSequence in, int start) {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/io/JsonReaderEx", "<init>"));
        }
        this(in, start, new int[32]);
        this.stack[this.stackSize++] = 6;
    }

    private JsonReaderEx(@NotNull CharSequence in, int start, @NotNull int[] stack) {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/io/JsonReaderEx", "<init>"));
        }
        if (stack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "org/jetbrains/io/JsonReaderEx", "<init>"));
        }
        this.lenient = false;
        this.peeked = 0;
        this.stackSize = 0;
        this.in = in;
        this.position = start;
        this.limit = in.length();
        this.stack = stack;
    }

    @Nullable
    public JsonReaderEx subReader() {
        JsonToken nextToken = this.peek();
        switch (nextToken) {
            case BEGIN_ARRAY: 
            case BEGIN_OBJECT: 
            case STRING: 
            case NUMBER: 
            case BOOLEAN: {
                break;
            }
            case NULL: {
                return null;
            }
            default: {
                throw this.createParseError("Cannot create sub reader, next token " + nextToken + " is not value");
            }
        }
        JsonReaderEx subReader = new JsonReaderEx(this.in, this.position, Arrays.copyOf(this.stack, this.stack.length));
        subReader.stackSize = this.stackSize;
        subReader.peeked = this.peeked;
        subReader.peekedLong = this.peekedLong;
        subReader.peekedNumberLength = this.peekedNumberLength;
        subReader.peekedString = this.peekedString;
        return subReader;
    }

    @Nullable
    public JsonReaderEx createSubReaderAndSkipValue() {
        JsonReaderEx subReader = this.subReader();
        this.skipValue();
        return subReader;
    }

    public final void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public final JsonReaderEx lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    public void beginArray() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 3) {
            throw this.createParseError("Expected BEGIN_ARRAY but was " + this.peek());
        }
        this.push(1);
        this.peeked = 0;
    }

    public void endArray() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 4) {
            --this.stackSize;
        } else {
            throw this.createParseError("Expected END_ARRAY but was " + this.peek());
        }
        this.peeked = 0;
    }

    public JsonReaderEx beginObject() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 1) {
            throw this.createParseError("Expected BEGIN_OBJECT but was " + this.peek());
        }
        this.push(3);
        this.peeked = 0;
        return this;
    }

    public void endObject() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 2) {
            --this.stackSize;
        } else {
            throw new IllegalStateException("Expected END_OBJECT but was " + this.peek());
        }
        this.peeked = 0;
    }

    public boolean hasNext() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        return p != 2 && p != 4;
    }

    public JsonToken peek() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        switch (p) {
            case 1: {
                return JsonToken.BEGIN_OBJECT;
            }
            case 2: {
                return JsonToken.END_OBJECT;
            }
            case 3: {
                return JsonToken.BEGIN_ARRAY;
            }
            case 4: {
                return JsonToken.END_ARRAY;
            }
            case 12: 
            case 13: 
            case 14: {
                return JsonToken.NAME;
            }
            case 5: 
            case 6: {
                return JsonToken.BOOLEAN;
            }
            case 7: {
                return JsonToken.NULL;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonToken.STRING;
            }
            case 15: 
            case 16: {
                return JsonToken.NUMBER;
            }
            case 17: {
                return JsonToken.END_DOCUMENT;
            }
        }
        throw new AssertionError();
    }

    private int doPeek() {
        int result2;
        int c;
        int peekStack;
        block47: {
            block49: {
                block48: {
                    block46: {
                        peekStack = this.stack[this.stackSize - 1];
                        if (peekStack != 1) break block46;
                        this.stack[this.stackSize - 1] = 2;
                        break block47;
                    }
                    if (peekStack != 2) break block48;
                    c = this.nextNonWhitespace(true);
                    switch (c) {
                        case 93: {
                            this.peeked = 4;
                            return 4;
                        }
                        case 59: {
                            this.checkLenient();
                        }
                        case 44: {
                            break;
                        }
                        default: {
                            throw this.createParseError("Unterminated array");
                        }
                    }
                    break block47;
                }
                if (peekStack == 3 || peekStack == 5) {
                    int c2;
                    this.stack[this.stackSize - 1] = 4;
                    if (peekStack == 5) {
                        c2 = this.nextNonWhitespace(true);
                        switch (c2) {
                            case 125: {
                                this.peeked = 2;
                                return 2;
                            }
                            case 59: {
                                this.checkLenient();
                            }
                            case 44: {
                                break;
                            }
                            default: {
                                throw this.createParseError("Unterminated object");
                            }
                        }
                    }
                    c2 = this.nextNonWhitespace(true);
                    switch (c2) {
                        case 34: {
                            this.peeked = 13;
                            return 13;
                        }
                        case 39: {
                            this.checkLenient();
                            this.peeked = 12;
                            return 12;
                        }
                        case 125: {
                            if (peekStack != 5) {
                                this.peeked = 2;
                                return 2;
                            }
                            throw this.createParseError("Expected name");
                        }
                    }
                    this.checkLenient();
                    --this.position;
                    if (this.isLiteral((char)c2)) {
                        this.peeked = 14;
                        return 14;
                    }
                    throw this.createParseError("Expected name");
                }
                if (peekStack != 4) break block49;
                this.stack[this.stackSize - 1] = 5;
                c = this.nextNonWhitespace(true);
                switch (c) {
                    case 58: {
                        break;
                    }
                    case 61: {
                        this.checkLenient();
                        if (this.position < this.limit && this.in.charAt(this.position) == '>') {
                            ++this.position;
                            break;
                        }
                        break block47;
                    }
                    default: {
                        throw this.createParseError("Expected ':'");
                    }
                }
                break block47;
            }
            if (peekStack == 6) {
                if (this.lenient) {
                    this.consumeNonExecutePrefix();
                }
                this.stack[this.stackSize - 1] = 7;
            } else if (peekStack == 7) {
                c = this.nextNonWhitespace(false);
                if (c == -1) {
                    this.peeked = 17;
                    return 17;
                }
                this.checkLenient();
                --this.position;
            } else if (peekStack == 8) {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        c = this.nextNonWhitespace(true);
        switch (c) {
            case 93: {
                if (peekStack == 1) {
                    this.peeked = 4;
                    return 4;
                }
            }
            case 44: 
            case 59: {
                if (peekStack == 1 || peekStack == 2) {
                    this.checkLenient();
                    --this.position;
                    this.peeked = 7;
                    return 7;
                }
                throw this.createParseError("Unexpected value");
            }
            case 39: {
                this.checkLenient();
                this.peeked = 8;
                return 8;
            }
            case 34: {
                if (this.stackSize == 1) {
                    this.checkLenient();
                }
                this.peeked = 9;
                return 9;
            }
            case 91: {
                this.peeked = 3;
                return 3;
            }
            case 123: {
                this.peeked = 1;
                return 1;
            }
        }
        --this.position;
        if (this.stackSize == 1) {
            this.checkLenient();
        }
        if ((result2 = this.peekKeyword()) != 0) {
            return result2;
        }
        result2 = this.peekNumber();
        if (result2 != 0) {
            return result2;
        }
        if (!this.isLiteral(this.in.charAt(this.position))) {
            throw this.createParseError("Expected value");
        }
        this.checkLenient();
        this.peeked = 10;
        return 10;
    }

    private int peekKeyword() {
        int peeking;
        String keywordUpper;
        String keyword;
        char c = this.in.charAt(this.position);
        if (c == 't' || c == 'T') {
            keyword = "true";
            keywordUpper = "TRUE";
            peeking = 5;
        } else if (c == 'f' || c == 'F') {
            keyword = "false";
            keywordUpper = "FALSE";
            peeking = 6;
        } else if (c == 'n' || c == 'N') {
            keyword = "null";
            keywordUpper = "NULL";
            peeking = 7;
        } else {
            return 0;
        }
        int length = keyword.length();
        for (int i2 = 1; i2 < length; ++i2) {
            if (this.position + i2 >= this.limit) {
                return 0;
            }
            c = this.in.charAt(this.position + i2);
            if (c == keyword.charAt(i2) || c == keywordUpper.charAt(i2)) continue;
            return 0;
        }
        if (this.position + length < this.limit && this.isLiteral(this.in.charAt(this.position + length))) {
            return 0;
        }
        this.position += length;
        this.peeked = peeking;
        return this.peeked;
    }

    private int peekNumber() {
        CharSequence in = this.in;
        int p = this.position;
        int l = this.limit;
        long value2 = 0L;
        boolean negative = false;
        boolean fitsInLong = true;
        int last = 0;
        int i2 = 0;
        block6: while (true) {
            if (p + i2 == l) {
                if (i2 == this.limit) {
                    return 0;
                }
                p = this.position;
                l = this.limit;
            }
            char c = in.charAt(p + i2);
            switch (c) {
                case '-': {
                    if (last == 0) {
                        negative = true;
                        last = 1;
                        break;
                    }
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case '+': {
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case 'E': 
                case 'e': {
                    if (last == 2 || last == 4) {
                        last = 5;
                        break;
                    }
                    return 0;
                }
                case '.': {
                    if (last == 2) {
                        last = 3;
                        break;
                    }
                    return 0;
                }
                default: {
                    if (c < '0' || c > '9') {
                        if (!this.isLiteral(c)) break block6;
                        return 0;
                    }
                    if (last == 1 || last == 0) {
                        value2 = -(c - 48);
                        last = 2;
                        break;
                    }
                    if (last == 2) {
                        if (value2 == 0L) {
                            return 0;
                        }
                        long newValue = value2 * 10L - (long)(c - 48);
                        fitsInLong &= value2 > -922337203685477580L || value2 == -922337203685477580L && newValue < value2;
                        value2 = newValue;
                        break;
                    }
                    if (last == 3) {
                        last = 4;
                        break;
                    }
                    if (last != 5 && last != 6) break;
                    last = 7;
                }
            }
            ++i2;
        }
        if (last == 2 && fitsInLong && (value2 != Long.MIN_VALUE || negative)) {
            this.peekedLong = negative ? value2 : -value2;
            this.position += i2;
            this.peeked = 15;
            return 15;
        }
        if (last == 2 || last == 4 || last == 7) {
            this.peekedNumberLength = i2;
            this.peeked = 16;
            return 16;
        }
        return 0;
    }

    private void consumeNonExecutePrefix() {
        this.nextNonWhitespace(true);
        --this.position;
        if (this.position + NON_EXECUTE_PREFIX.length > this.limit) {
            return;
        }
        for (int i2 = 0; i2 < NON_EXECUTE_PREFIX.length; ++i2) {
            if (this.in.charAt(this.position + i2) == NON_EXECUTE_PREFIX[i2]) continue;
            return;
        }
        this.position += NON_EXECUTE_PREFIX.length;
    }

    private boolean isLiteral(char c) {
        switch (c) {
            case '#': 
            case '/': 
            case ';': 
            case '=': 
            case '\\': {
                this.checkLenient();
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    public String nextName() {
        String result2 = this.nextNameOrNull();
        if (result2 == null) {
            throw this.createParseError("Expected a name but was " + this.peek());
        }
        return result2;
    }

    @Nullable
    public String nextNameOrNull() {
        String result2;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 14) {
            result2 = this.nextUnquotedValue();
        } else if (p == 12) {
            result2 = this.nextQuotedValue('\'');
        } else if (p == 13) {
            result2 = this.nextQuotedValue('\"');
        } else {
            if (p != 2 && p != 4) {
                throw this.createParseError("Expected a name but was " + this.peek());
            }
            return null;
        }
        this.peeked = 0;
        return result2;
    }

    public CharSequence nextNameAsCharSequence() {
        return this.nextName();
    }

    public String nextAsString() {
        return this.peek() == JsonToken.STRING ? this.nextString() : null;
    }

    public String nextNullableString() {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        return this.nextString();
    }

    public String nextString() {
        return this.nextString(false);
    }

    public String nextString(boolean anyPrimitiveAsString) {
        String result2;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 10) {
            result2 = this.nextUnquotedValue();
        } else if (p == 8) {
            result2 = this.nextQuotedValue('\'');
        } else if (p == 9) {
            result2 = this.nextQuotedValue('\"');
        } else if (p == 11) {
            result2 = this.peekedString;
            this.peekedString = null;
        } else if (p == 15) {
            result2 = Long.toString(this.peekedLong);
        } else if (p == 16) {
            int end = this.position + this.peekedNumberLength;
            result2 = this.in.subSequence(this.position, end).toString();
            this.position = end;
        } else if (anyPrimitiveAsString && p == 5) {
            result2 = "true";
        } else if (anyPrimitiveAsString && p == 6) {
            result2 = "false";
        } else if (anyPrimitiveAsString && p == 7) {
            result2 = "null";
        } else {
            throw this.createParseError("Expected a string but was " + this.peek());
        }
        this.peeked = 0;
        return result2;
    }

    public boolean nextBoolean() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 5) {
            this.peeked = 0;
            return true;
        }
        if (p == 6) {
            this.peeked = 0;
            return false;
        }
        throw this.createParseError("Expected a boolean but was " + this.peek());
    }

    public void nextNull() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 7) {
            throw this.createParseError("Expected null but was " + this.peek());
        }
        this.peeked = 0;
    }

    public double nextDouble() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 15) {
            this.peeked = 0;
            return this.peekedLong;
        }
        if (p == 16) {
            int end = this.position + this.peekedNumberLength;
            this.peekedString = this.in.subSequence(this.position, end).toString();
            this.position = end;
        } else if (p == 8 || p == 9) {
            this.peekedString = this.nextQuotedValue(p == 8 ? (char)'\'' : '\"');
        } else if (p == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (p != 11) {
            throw this.createParseError("Expected a double but was " + this.peek());
        }
        this.peeked = 11;
        double result2 = Double.parseDouble(this.peekedString);
        if (!this.lenient && (Double.isNaN(result2) || Double.isInfinite(result2))) {
            throw this.createParseError("JSON forbids NaN and infinities: " + result2);
        }
        this.peekedString = null;
        this.peeked = 0;
        return result2;
    }

    public long nextLong() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 15) {
            this.peeked = 0;
            return this.peekedLong;
        }
        if (p == 16) {
            int end = this.position + this.peekedNumberLength;
            this.peekedString = this.in.subSequence(this.position, end).toString();
            this.position = end;
        } else if (p == 8 || p == 9) {
            this.peekedString = this.nextQuotedValue(p == 8 ? (char)'\'' : '\"');
            try {
                long result2 = Long.parseLong(this.peekedString);
                this.peeked = 0;
                return result2;
            }
            catch (NumberFormatException result2) {}
        } else {
            throw this.createParseError("Expected a long but was " + this.peek());
        }
        this.peeked = 11;
        double asDouble = Double.parseDouble(this.peekedString);
        long result3 = (long)asDouble;
        if ((double)result3 != asDouble) {
            throw new NumberFormatException("Expected a long but was " + this.peekedString + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.peekedString = null;
        this.peeked = 0;
        return result3;
    }

    private String nextQuotedValue(char quote) {
        CharSequence in = this.in;
        int p = this.position;
        int l = this.limit;
        int start = p;
        StringBuilder builder = null;
        while (p < l) {
            char c;
            if ((c = in.charAt(p++)) == quote) {
                this.position = p;
                if (builder == null) {
                    return in.subSequence(start, p - 1).toString();
                }
                return builder.append(in, start, p - 1).toString();
            }
            if (c != '\\') continue;
            this.position = p;
            if (builder == null) {
                if (this.builder == null) {
                    this.builder = new StringBuilder(p - start + 16);
                } else {
                    this.builder.setLength(0);
                }
                builder = this.builder;
            }
            builder.append(in, start, p - 1);
            builder.append(this.readEscapeCharacter());
            p = this.position;
            l = this.limit;
            start = p;
        }
        this.position = p;
        throw this.createParseError("Unterminated string");
    }

    private String nextUnquotedValue() {
        int i2;
        block4: for (i2 = this.position; i2 < this.limit; ++i2) {
            switch (this.in.charAt(i2)) {
                case '#': 
                case '/': 
                case ';': 
                case '=': 
                case '\\': {
                    this.checkLenient();
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        String result2 = this.in.subSequence(this.position, i2).toString();
        this.position = i2;
        return result2;
    }

    private void skipQuotedValue(char quote) {
        CharSequence in = this.in;
        int p = this.position;
        int l = this.limit;
        while (p < l) {
            char c;
            if ((c = in.charAt(p++)) == quote) {
                this.position = p;
                return;
            }
            if (c != '\\') continue;
            this.position = p;
            this.readEscapeCharacter();
            p = this.position;
            l = this.limit;
        }
        this.position = p;
        throw this.createParseError("Unterminated string");
    }

    private void skipUnquotedValue() {
        int i2;
        for (i2 = this.position; i2 < this.limit; ++i2) {
            switch (this.in.charAt(i2)) {
                case '#': 
                case '/': 
                case ';': 
                case '=': 
                case '\\': {
                    this.checkLenient();
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    this.position = i2;
                    return;
                }
            }
        }
        this.position = i2;
    }

    public int nextInt() {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 15) {
            int result2 = (int)this.peekedLong;
            if (this.peekedLong != (long)result2) {
                throw new NumberFormatException("Expected an int but was " + this.peekedLong + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
            }
            this.peeked = 0;
            return result2;
        }
        if (p == 16) {
            int end = this.position + this.peekedNumberLength;
            this.peekedString = this.in.subSequence(this.position, end).toString();
            this.position = end;
        } else if (p == 8 || p == 9) {
            this.peekedString = this.nextQuotedValue(p == 8 ? (char)'\'' : '\"');
            try {
                int result3 = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                return result3;
            }
            catch (NumberFormatException end) {}
        } else {
            throw this.createParseError("Expected an int but was " + this.peek());
        }
        this.peeked = 11;
        double asDouble = Double.parseDouble(this.peekedString);
        int result4 = (int)asDouble;
        if ((double)result4 != asDouble) {
            throw new NumberFormatException("Expected an int but was " + this.peekedString + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
        }
        this.peekedString = null;
        this.peeked = 0;
        return result4;
    }

    @Override
    public void close() {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
    }

    public void skipValue() {
        int count = 0;
        do {
            int p;
            if ((p = this.peeked) == 0) {
                p = this.doPeek();
            }
            if (p == 3) {
                this.push(1);
                ++count;
            } else if (p == 1) {
                this.push(3);
                ++count;
            } else if (p == 4 || p == 2) {
                --this.stackSize;
                --count;
            } else if (p == 14 || p == 10) {
                this.skipUnquotedValue();
            } else if (p == 8 || p == 12) {
                this.skipQuotedValue('\'');
            } else if (p == 9 || p == 13) {
                this.skipQuotedValue('\"');
            } else if (p == 16) {
                this.position += this.peekedNumberLength;
            }
            this.peeked = 0;
        } while (count != 0);
    }

    public void skipValues() {
        while (this.hasNext()) {
            this.skipValue();
        }
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            int[] newStack = new int[this.stackSize * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stackSize);
            this.stack = newStack;
        }
        this.stack[this.stackSize++] = newTop;
    }

    private int getLineNumber() {
        int result2 = 1;
        for (int i2 = 0; i2 < this.position; ++i2) {
            if (this.in.charAt(i2) != '\n') continue;
            ++result2;
        }
        return result2;
    }

    private int getColumnNumber() {
        int result2 = 1;
        for (int i2 = 0; i2 < this.position; ++i2) {
            if (this.in.charAt(i2) == '\n') {
                result2 = 1;
                continue;
            }
            ++result2;
        }
        return result2;
    }

    private int nextNonWhitespace(boolean throwOnEof) {
        int p;
        block10: {
            char c;
            CharSequence in = this.in;
            p = this.position;
            int l = this.limit;
            block4: while (true) {
                if (p == l) break block10;
                if ((c = in.charAt(p++)) == '\n' || c == ' ' || c == '\r' || c == '\t') continue;
                if (c == '/') {
                    this.position = p;
                    if (p == l) {
                        --this.position;
                        boolean charsLoaded = this.position + 3 < this.limit;
                        ++this.position;
                        if (!charsLoaded) {
                            return c;
                        }
                    }
                    this.checkLenient();
                    char peek = in.charAt(this.position);
                    switch (peek) {
                        case '*': {
                            ++this.position;
                            if (!this.skipTo("*/")) {
                                throw this.createParseError("Unterminated comment");
                            }
                            p = this.position + 2;
                            l = this.limit;
                            continue block4;
                        }
                        case '/': {
                            ++this.position;
                            this.skipToEndOfLine();
                            p = this.position;
                            l = this.limit;
                            continue block4;
                        }
                    }
                    return c;
                }
                if (c != '#') break;
                this.position = p;
                this.checkLenient();
                this.skipToEndOfLine();
                p = this.position;
                l = this.limit;
            }
            this.position = p;
            return c;
        }
        this.position = p;
        if (throwOnEof) {
            throw this.createParseError("End of input");
        }
        return -1;
    }

    private void checkLenient() {
        if (!this.lenient) {
            throw this.createParseError("Use JsonReaderEx.setLenient(true) to accept malformed JSON");
        }
    }

    private void skipToEndOfLine() {
        char c;
        while (this.position < this.limit && (c = this.in.charAt(this.position++)) != '\n' && c != '\r') {
        }
    }

    private boolean skipTo(String toFind) {
        while (this.position + toFind.length() <= this.limit) {
            block4: {
                if (this.in.charAt(this.position) != '\n') {
                    for (int c = 0; c < toFind.length(); ++c) {
                        if (this.in.charAt(this.position + c) == toFind.charAt(c)) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            ++this.position;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " at line " + this.getLineNumber() + " column " + this.getColumnNumber();
    }

    private char readEscapeCharacter() {
        if (this.position == this.limit) {
            throw this.createParseError("Unterminated escape sequence");
        }
        char escaped = this.in.charAt(this.position++);
        switch (escaped) {
            case 'u': {
                int i2;
                if (this.position + 4 > this.limit) {
                    throw this.createParseError("Unterminated escape sequence");
                }
                char result2 = '\u0000';
                int end = i2 + 4;
                for (i2 = this.position; i2 < end; ++i2) {
                    char c = this.in.charAt(i2);
                    result2 = (char)(result2 << 4);
                    if (c >= '0' && c <= '9') {
                        result2 = (char)(result2 + (c - 48));
                        continue;
                    }
                    if (c >= 'a' && c <= 'f') {
                        result2 = (char)(result2 + (c - 97 + 10));
                        continue;
                    }
                    if (c >= 'A' && c <= 'F') {
                        result2 = (char)(result2 + (c - 65 + 10));
                        continue;
                    }
                    throw new NumberFormatException("\\u" + this.in.subSequence(this.position, this.position + 4));
                }
                this.position += 4;
                return result2;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return escaped;
    }

    private JsonParseException createParseError(String message2) {
        throw new JsonParseException(message2 + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    private static final class JsonScope {
        static final int EMPTY_ARRAY = 1;
        static final int NONEMPTY_ARRAY = 2;
        static final int EMPTY_OBJECT = 3;
        static final int DANGLING_NAME = 4;
        static final int NONEMPTY_OBJECT = 5;
        static final int EMPTY_DOCUMENT = 6;
        static final int NONEMPTY_DOCUMENT = 7;
        static final int CLOSED = 8;

        private JsonScope() {
        }
    }
}

