/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProviderBase;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerEditorsProvider
extends XDebuggerEditorsProviderBase {
    @NotNull
    public FileType getFileType() {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        if (javaFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "getFileType"));
        }
        return javaFileType;
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project2, @NotNull String text2, @Nullable PsiElement context, boolean isPhysical) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpressionCodeFragment"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpressionCodeFragment"));
        }
        return JavaCodeFragmentFactory.getInstance((Project)project2).createExpressionCodeFragment(text2, context, null, isPhysical);
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@Nullable PsiElement context) {
        Collection collection = DebuggerUtilsEx.getCodeFragmentFactories(context).stream().map(factory -> factory.getFileType().getLanguage()).collect(Collectors.toList());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "getSupportedLanguages"));
        }
        return collection;
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@NotNull Project project2, @Nullable XSourcePosition sourcePosition) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "getSupportedLanguages"));
        }
        if (sourcePosition != null) {
            Collection<Language> collection = this.getSupportedLanguages(this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project2));
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "getSupportedLanguages"));
            }
            return collection;
        }
        List<Language> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "getSupportedLanguages"));
        }
        return list2;
    }

    @NotNull
    public XExpression createExpression(@NotNull Project project2, @NotNull Document document, @Nullable Language language, @NotNull EvaluationMode mode) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpression"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpression"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpression"));
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (psiFile != null) {
            XExpressionImpl xExpressionImpl = new XExpressionImpl(document.getText(), language, StringUtil.nullize((String)((JavaCodeFragment)psiFile).importsToString()), mode);
            if (xExpressionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpression"));
            }
            return xExpressionImpl;
        }
        XExpression xExpression = super.createExpression(project2, document, language, mode);
        if (xExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpression"));
        }
        return xExpression;
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project2, @NotNull XExpression expression2, @Nullable PsiElement context, boolean isPhysical) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpressionCodeFragment"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider", "createExpressionCodeFragment"));
        }
        TextWithImports text2 = TextWithImportsImpl.fromXExpression(expression2);
        if (text2 != null) {
            CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text2, context);
            JavaCodeFragment codeFragment = factory.createPresentationCodeFragment(text2, context, project2);
            if (context != null) {
                PsiClass contextClass;
                PsiType contextType = (PsiType)context.getUserData(DebuggerUtilsImpl.PSI_TYPE_KEY);
                if (contextType == null && (contextClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiClass.class})) != null) {
                    contextType = JavaPsiFacade.getInstance((Project)codeFragment.getProject()).getElementFactory().createType(contextClass);
                }
                codeFragment.setThisType(contextType);
            }
            return codeFragment;
        }
        return super.createExpressionCodeFragment(project2, expression2, context, isPhysical);
    }
}

